/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.bean;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import org.json.JSONObject;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class AssistantRequest {
    public static final String FIELDS = "fields";
    private AssistantAction assistantAction;
    private AssistantButton button;
    private JSONObject data;
    private JSONObject fields;
    private int masterId;

    public AssistantRequest(AssistantAction assistantAction, String data) {
        this(assistantAction, data, null);
    }

    public AssistantRequest(AssistantAction assistantAction, String data, AssistantButton button) {
        this.assistantAction = assistantAction;
        this.button = button;
        this.data = new JSONObject(data == null ? "{}" : data);
        this.fields = this.data.optJSONObject(FIELDS);
    }

    public AssistantAction getAssistantAction() {
        return this.assistantAction;
    }

    public AssistantButton getButton() {
        return this.button;
    }

    public JSONObject getData() {
        return this.data;
    }

    public int getContractId() {
        return this.data.optInt("contractId", 0);
    }

    public int getMasterId() {
        return this.masterId;
    }

    public void setMasterId(int masterId) {
        this.masterId = masterId;
    }

    public int getFieldInt(String key) {
        Objects.requireNonNull(key);
        int value = 0;
        if (this.fields != null) {
            value = this.fields.optInt(key);
        }
        return value;
    }

    public String getFieldString(String key) {
        Objects.requireNonNull(key);
        String value = null;
        if (this.fields != null) {
            value = this.fields.optString(key);
        }
        return value;
    }

    public LocalDate getFieldDate(String key) {
        Objects.requireNonNull(key);
        LocalDate value = null;
        if (this.fields != null) {
            String date = this.fields.optString(key);
            value = Utils.notBlankString((String)date) ? LocalDate.parse(date) : null;
        }
        return value;
    }

    public Period getFieldPeriod(String key) {
        JSONObject p;
        Objects.requireNonNull(key);
        Period value = null;
        if (this.fields != null && (p = this.fields.optJSONObject(key)) != null) {
            String f = p.getString("from");
            LocalDate from = Utils.notBlankString((String)f) ? LocalDate.parse(f) : null;
            String t = p.getString("to");
            LocalDate to = Utils.notBlankString((String)t) ? LocalDate.parse(t) : null;
            value = new Period(from, to);
        }
        return value;
    }

    public BigDecimal getFieldBigDecimal(String key) {
        Objects.requireNonNull(key);
        BigDecimal value = null;
        if (this.fields != null) {
            value = Utils.parseBigDecimal((String)this.fields.optString(key), null);
        }
        return value;
    }

    public JSONObject getFields() {
        return this.fields;
    }
}

