/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.action;

import bitel.billing.server.ActionConType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.action.base.ActionBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

@ActionConType(value=2)
public class ActionGetLastSession
extends ActionBase {
    public void doAction() throws Exception {
        int loginId = this.getIntParameter("login_id", -1);
        Calendar dateFrom = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date_from", null));
        Calendar dateTo = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date_to", new Date()));
        if (this.mid <= 0 || loginId <= 0 || dateFrom == null || TimeUtils.dateBefore((Calendar)dateTo, (Calendar)dateFrom)) {
            throw new BGIllegalArgumentException();
        }
        String nasTableName = "nas_" + this.mid;
        while (TimeUtils.monthsDelta((Calendar)dateFrom, (Calendar)dateTo) >= 0) {
            String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)TimeUtils.convertCalendarToDate((Calendar)dateTo), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionTableName)) {
                String query = "SELECT session.id, session_start, session_stop, login_name, session.ipaddr, from_number, to_number, nas.identifier, session.lr FROM " + sessionTableName + " AS session LEFT JOIN " + nasTableName + " AS nas ON session.nas_id=nas.id WHERE session.lid=? ";
                query = query + "ORDER BY session.id DESC LIMIT 1";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, loginId);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int pos = 1;
                    Element sessionData = this.createElement(this.rootNode, "session");
                    sessionData.setAttribute("id", rs.getString(pos++));
                    sessionData.setAttribute("session_start", TimeUtils.formatFullDate((Date)rs.getTimestamp(pos++)));
                    sessionData.setAttribute("session_stop", TimeUtils.formatFullDate((Date)rs.getTimestamp(pos++)));
                    sessionData.setAttribute("login_name", rs.getString(pos++));
                    sessionData.setAttribute("ipaddr", IPUtils.convertLongIpToString((long)rs.getLong(pos++)));
                    sessionData.setAttribute("from_number", rs.getString(pos++));
                    sessionData.setAttribute("to_number", rs.getString(pos++));
                    sessionData.setAttribute("nas", rs.getString(pos++));
                    sessionData.setAttribute("lr", rs.getString(pos++));
                    break;
                }
                rs.close();
                ps.close();
            }
            dateTo.add(2, -1);
        }
    }
}

