/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client.bean;

import bitel.billing.module.common.ToolBarControlInterface;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.plugins.im.client.ActionIMManager;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.common.client.BGFlashButton;

public class IMButton
extends BGFlashButton
implements ToolBarControlInterface {
    static List<Icon> iconList = new ArrayList<Icon>();

    public IMButton() {
        super(iconList, 500L, true);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setMinimumSize(new Dimension(24, 24));
        this.setPreferredSize(new Dimension(24, 24));
        this.setMaximumSize(new Dimension(24, 24));
        this.addActionListener(e -> {
            ActionIMManager BA = new ActionIMManager();
            BA.actionPerformed(e);
        });
    }

    public void setToolData(Node toolBar) {
        PluginClientListener.toolbarIMButton = this;
        this.refreshStatusIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNewMessagesCount() {
        int totalCount = 0;
        StringBuilder sb = new StringBuilder(256);
        Map<String, Integer> map = PluginClientListener.imManager.getCountNewMessagesMap();
        synchronized (map) {
            for (Map.Entry<String, Integer> jidMess : PluginClientListener.imManager.getCountNewMessagesMap().entrySet()) {
                totalCount += jidMess.getValue().intValue();
                sb.append("<br>").append(PluginClientListener.imManager.getNameFromJid(jidMess.getKey())).append(" (").append(jidMess.getValue()).append(")");
            }
        }
        final StringBuilder sbToolTip = new StringBuilder(256);
        if (totalCount > 0) {
            sbToolTip.append("<html><b>").append(totalCount).append(" \u043d\u043e\u0432\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439:</b>").append((CharSequence)sb).append("</html>");
            this.startFlash(0, 1);
        } else {
            sbToolTip.append("\u041d\u0435\u0442 \u043d\u043e\u0432\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439.");
            this.stopFlash();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IMButton.this.setToolTipText(sbToolTip.toString());
            }
        });
    }

    public void refreshStatusIcon() {
        try {
            IMConstants.STATUS currStatus = PluginClientListener.imManager != null ? PluginClientListener.imManager.getComboBoxStatus() : IMConstants.STATUS.OFFLINE;
            this.setIconToIndex(0, PluginClientListener.statusIcon.get(currStatus), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        iconList.add(PluginClientListener.emailIcon);
        iconList.add(PluginClientListener.emailIcon);
    }
}

