/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;

public class ConnectionMapAuto
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    protected final Accounting accounting;
    public final ConcurrentMap<Integer, ConcurrentMap<Integer, InetConnectionAutoRuntime>> autoSessionMap = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, InetConnectionAutoRuntime>>();
    private final boolean closeOld;
    private boolean realtimeInited = false;

    public ConnectionMapAuto(Accounting accounting) throws BGException {
        this.accounting = accounting;
        ModuleSetup moduleSetup = this.accounting.setup.getModuleSetup(Integer.valueOf(accounting.moduleId));
        this.closeOld = moduleSetup != null && moduleSetup.getInt("connection.checkDuplicate", 0) > 0;
    }

    public ConcurrentMap<Integer, InetConnectionAutoRuntime> getDeviceMap(Integer deviceId) {
        return (ConcurrentMap)this.autoSessionMap.get(deviceId);
    }

    public Iterable<InetConnectionAutoRuntime> iterable() {
        return new Iterable<InetConnectionAutoRuntime>(){

            @Override
            public Iterator<InetConnectionAutoRuntime> iterator() {
                return new Iter();
            }
        };
    }

    public synchronized void init(ConnectionSet connectionSet) throws BGException {
        if (this.accounting.realtime && !this.realtimeInited) {
            this.realtimeInited = true;
            this.initRealtime();
        }
        logger.info("Init auto sessions");
        Connection con = connectionSet.getConnection();
        InetDevice device = new InetDeviceDao(con, this.accounting.moduleId).node(null, this.accounting.rootDeviceId, false);
        Set servTypeIds = Id.newIdSet(new InetServTypeDao(con, this.accounting.moduleId).list(1));
        if (servTypeIds.size() > 0) {
            InetSessionDao inetSessionDao = new InetSessionDao(con, this.accounting.moduleId);
            TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(con);
            try {
                this.init(connectionSet, con, device, servTypeIds, inetSessionDao, tariffModuleTreeSetDao);
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void initRealtime() throws BGException {
        EventProcessor.getInstance().addListener((EventListener)this, InetServModifiedEvent.class, this.accounting.moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, InetServDeviceStateAndOptionsModifiedEvent.class, this.accounting.moduleId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ConnectionSet connectionSet, Connection con, InetDevice device, Set<Integer> servTypeIds, InetSessionDao inetSessionDao, TariffModuleTreeSetDao tariffTreeSetDao) throws BGException, SQLException {
        long start = System.currentTimeMillis();
        ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.getSessionMap(device.getId(), null);
        PreparedStatement monthCounterDetailPS = con.prepareStatement("SELECT trafficTypeId, SUM(amount), MIN(day) as hh FROM inet_session_detail_" + this.accounting.moduleId + " as detail WHERE sessionId=? AND trafficTypeId=0 GROUP BY trafficTypeId");
        ServerContext context = (ServerContext)ServerContext.get();
        Directory inetServTypeDir = context.getDirectory(InetServType.class, this.accounting.moduleId);
        List<Object> inetServList = inetSessionDao.listAuto(device.getId(), servTypeIds, this.accounting.initialDate);
        for (Object object : inetServList) {
            int inetServId;
            InetSession inetSession;
            InetConnection inetConnection;
            if (object instanceof Object[]) {
                inetConnection = (InetConnection)((Object[])object)[0];
                inetSession = (InetSession)((Object[])object)[1];
                inetServId = inetConnection.getServId();
            } else {
                inetConnection = null;
                inetSession = null;
                inetServId = (Integer)object;
            }
            InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(inetServId);
            if (inetServRuntime == null) {
                logger.error("InetServ not found with id=" + inetServId);
                continue;
            }
            inetServRuntime.lock();
            try {
                block23: {
                    if (this.closeOld) {
                        try {
                            InetConnectionAutoRuntime oldConnectionRuntime = (InetConnectionAutoRuntime)((Object)sessionMap.get(inetServId));
                            if (oldConnectionRuntime == null) break block23;
                            InetSessionLog sessionLog = inetSessionDao.getAsLog(inetServTypeDir.list(), oldConnectionRuntime.sessionId);
                            Date lastActive = sessionLog.getLastActive();
                            try (BalanceDao balanceDao = new BalanceDao(con);){
                                oldConnectionRuntime.forceFinish(this.accounting, connectionSet, balanceDao, false, lastActive.getTime());
                            }
                        }
                        catch (Exception ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                InetConnectionAutoRuntime newConnectionRuntime = new InetConnectionAutoRuntime(this.accounting, inetServRuntime, inetConnection, inetSession);
                if (inetSession != null) {
                    try {
                        newConnectionRuntime.setAccountingPeriod(this.accounting, connectionSet, newConnectionRuntime.sessionStartTime, false);
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        Map<Integer, Long> counterMap = this.getCountersFromBD(monthCounterDetailPS, inetSession.getId());
                        for (Map.Entry<Integer, Long> entry : counterMap.entrySet()) {
                            int trafficTypeId = entry.getKey();
                            long amount = entry.getValue();
                            newConnectionRuntime.initCounterTraffic(trafficTypeId, amount);
                        }
                    }
                    catch (SQLException ex) {
                        throw new BGException((Throwable)ex);
                    }
                    this.accounting.registerAutoInetAddress(newConnectionRuntime.connection.getDeviceId(), newConnectionRuntime);
                }
                newConnectionRuntime.setInetOptions(inetServRuntime.getInetServ().getDeviceOptions());
                sessionMap.put(inetServId, newConnectionRuntime);
            }
            finally {
                inetServRuntime.unlock();
            }
        }
        if (device.getChildren() != null) {
            for (InetDevice child : device.getChildren()) {
                this.init(connectionSet, con, child, servTypeIds, inetSessionDao, tariffTreeSetDao);
            }
        }
        monthCounterDetailPS.close();
        logger.info("Auto connections loaded for " + (System.currentTimeMillis() - start) + " ms");
    }

    private Map<Integer, Long> getCountersFromBD(PreparedStatement monthCounterDetailPS, long sessionId) throws SQLException {
        HashMap<Integer, Long> counterMap = new HashMap<Integer, Long>();
        monthCounterDetailPS.setLong(1, sessionId);
        ResultSet rs = monthCounterDetailPS.executeQuery();
        while (rs.next()) {
            int trafficTypeId = rs.getInt(1);
            long amount = rs.getLong(2);
            counterMap.put(trafficTypeId, amount);
        }
        return counterMap;
    }

    public void loadCounters(ConnectionSet connectionSet) throws BGException {
        logger.info("Loading counters for call connections");
        long start = System.currentTimeMillis();
        Connection con = connectionSet.getConnection();
        InetDevice device = null;
        try (InetDeviceDao inetDeviceDao = new InetDeviceDao(con, this.accounting.moduleId);){
            device = inetDeviceDao.node(null, this.accounting.rootDeviceId, false);
        }
        ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.getSessionMap(device.getId(), null);
        try {
            PreparedStatement monthCounterDetailPS = con.prepareStatement("SELECT trafficTypeId, SUM(amount), MIN(day) as hh FROM inet_session_detail_" + this.accounting.moduleId + " as detail WHERE sessionId=? AND trafficTypeId=0 GROUP BY trafficTypeId");
            for (Map.Entry entry : sessionMap.entrySet()) {
                InetConnectionAutoRuntime connection = (InetConnectionAutoRuntime)((Object)entry.getValue());
                InetConnectionAutoRuntime inetCon = (InetConnectionAutoRuntime)((Object)sessionMap.get(connection.inetServId));
                Map<Integer, Long> counterMap = this.getCountersFromBD(monthCounterDetailPS, connection.sessionId);
                if (inetCon == null) continue;
                for (Map.Entry entry2 : inetCon.trafficsDelta.entrySet()) {
                    Map value = (Map)entry2.getValue();
                    for (Map.Entry delta : value.entrySet()) {
                        int traffTypeId = ((TrafficAmountKey)delta.getKey()).trafficTypeId;
                        Long amount = counterMap.get(traffTypeId);
                        if (amount == null) {
                            amount = 0L;
                        }
                        amount = amount + ((TrafficAmountDelta)delta.getValue()).flushAmountDelta;
                        counterMap.put(traffTypeId, amount);
                    }
                }
                for (Map.Entry<Object, Object> entry3 : counterMap.entrySet()) {
                    int trafficTypeId = (Integer)entry3.getKey();
                    long amount = (Long)entry3.getValue();
                    inetCon.initCounterTraffic(trafficTypeId, amount);
                }
            }
        }
        catch (SQLException e) {
            logger.error("", (Throwable)e);
        }
        logger.info("Counter loading completed for " + (System.currentTimeMillis() - start) + " ms");
    }

    private InetConnectionAutoRuntime newConnectionRuntime(ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap, InetServRuntime inetServRuntime) throws BGException {
        InetConnectionAutoRuntime newAccountingSession = new InetConnectionAutoRuntime(this.accounting, inetServRuntime, null, null);
        sessionMap.put(inetServRuntime.inetServId, newAccountingSession);
        return newAccountingSession;
    }

    protected ConcurrentMap<Integer, InetConnectionAutoRuntime> getSessionMap(Integer deviceId, Set<Integer> deviceIds) {
        ConcurrentMap sessionMap = (ConcurrentHashMap)this.autoSessionMap.get(deviceId);
        if (sessionMap == null) {
            if (deviceIds != null && !deviceIds.contains(deviceId)) {
                return null;
            }
            ConcurrentHashMap newSessionMap = new ConcurrentHashMap();
            sessionMap = this.autoSessionMap.putIfAbsent(deviceId, newSessionMap);
            if (sessionMap == null) {
                sessionMap = newSessionMap;
            }
        }
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof InetServModifiedEvent) {
            InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
            InetServ oldServ = ((InetServModifiedEvent)e).getOldInetServ();
            InetServ newServ = ((InetServModifiedEvent)e).getNewInetServ();
            AtomicReference inetServRef = this.accounting.servTypeRuntimeMap.getRef(oldServ != null ? oldServ.getTypeId() : newServ.getTypeId());
            InetServTypeRuntime inetServTypeRuntime = (InetServTypeRuntime)inetServRef.get();
            InetServType inetServ = inetServTypeRuntime.inetServType;
            if (inetServ.getSessionInitiationType() != 1) {
                return;
            }
            if (oldServ != null && newServ != null) {
                if (TimeUtils.dateEqual((Date)oldServ.getDateFrom(), (Date)newServ.getDateFrom()) && TimeUtils.dateEqual((Date)oldServ.getDateTo(), (Date)newServ.getDateTo()) && (oldServ.getAddressFrom() == null && newServ.getAddressFrom() == null || oldServ.getAddressFrom() != null && newServ.getAddressFrom() != null && IpAddress.equals((byte[])oldServ.getAddressFrom(), (byte[])newServ.getAddressFrom())) && (oldServ.getAddressTo() == null && newServ.getAddressTo() == null || oldServ.getAddressTo() != null && newServ.getAddressTo() != null && IpAddress.equals((byte[])oldServ.getAddressTo(), (byte[])newServ.getAddressTo())) && oldServ.getDeviceId() == newServ.getDeviceId()) {
                    return;
                }
                Integer oldDeviceId = oldServ.getDeviceId();
                Integer newDeviceId = newServ.getDeviceId();
                ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.getSessionMap(oldDeviceId, rootDeviceRuntime.descendantIds);
                if (sessionMap == null) {
                    return;
                }
                InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(newServ.getId());
                InetConnectionAutoRuntime connectionRuntime = (InetConnectionAutoRuntime)((Object)sessionMap.get(newServ.getId()));
                if (connectionRuntime == null) {
                    connectionRuntime = this.newConnectionRuntime(sessionMap, inetServRuntime);
                }
                connectionRuntime.inetServRuntime.lock();
                try {
                    this.accounting.unregisterAutoInetAddress(oldDeviceId, connectionRuntime, oldServ);
                    if (connectionRuntime.sessionId > 0L) {
                        ConnectionSet connectionSet = ctx.getConnectionSet();
                        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
                            connectionRuntime.forceFinish(this.accounting, connectionSet, balanceDao, true, System.currentTimeMillis());
                        }
                    }
                    connectionRuntime.setRangeSets(inetServRuntime.getInetServ());
                    this.accounting.registerAutoInetAddress(newDeviceId, connectionRuntime);
                }
                finally {
                    connectionRuntime.inetServRuntime.unlock();
                }
            }
            if (newServ != null) {
                Integer deviceId = newServ.getDeviceId();
                ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.getSessionMap(deviceId, rootDeviceRuntime.descendantIds);
                if (sessionMap == null) {
                    return;
                }
                InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(newServ.getId());
                InetConnectionAutoRuntime connectionRuntime = (InetConnectionAutoRuntime)((Object)sessionMap.get(newServ.getId()));
                inetServRuntime.lock();
                try {
                    if (connectionRuntime == null) {
                        connectionRuntime = this.newConnectionRuntime(sessionMap, inetServRuntime);
                    }
                    this.accounting.registerAutoInetAddress(deviceId, connectionRuntime);
                }
                finally {
                    inetServRuntime.unlock();
                }
            } else {
                Integer deviceId = oldServ.getDeviceId();
                ConcurrentMap sessionMap = (ConcurrentMap)this.autoSessionMap.get(deviceId);
                if (sessionMap == null) {
                    return;
                }
                InetConnectionAutoRuntime connectionRuntime = (InetConnectionAutoRuntime)((Object)sessionMap.get(oldServ.getId()));
                if (connectionRuntime == null) {
                    return;
                }
                connectionRuntime.inetServRuntime.lock();
                try {
                    this.accounting.unregisterAutoInetAddress(deviceId, connectionRuntime, oldServ);
                }
                finally {
                    connectionRuntime.inetServRuntime.unlock();
                }
            }
        } else if (e instanceof InetServDeviceStateAndOptionsModifiedEvent) {
            InetServDeviceStateAndOptionsModifiedEvent ev = (InetServDeviceStateAndOptionsModifiedEvent)e;
            Integer deviceId = ev.getDeviceId();
            Integer inetServId = ev.getServId();
            ConcurrentMap sessionMap = (ConcurrentMap)this.autoSessionMap.get(deviceId);
            if (sessionMap == null) {
                return;
            }
            InetConnectionAutoRuntime connectionRuntime = (InetConnectionAutoRuntime)((Object)sessionMap.get(inetServId));
            if (connectionRuntime == null) {
                return;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }

    private class Iter
    implements Iterator<InetConnectionAutoRuntime> {
        private final Iterator<ConcurrentMap<Integer, InetConnectionAutoRuntime>> deviceIterator;
        private Iterator<InetConnectionAutoRuntime> sessionIterator;
        private InetConnectionAutoRuntime current;

        Iter() {
            this.deviceIterator = ConnectionMapAuto.this.autoSessionMap.values().iterator();
            while (this.deviceIterator.hasNext()) {
                this.sessionIterator = this.deviceIterator.next().values().iterator();
                if (!this.sessionIterator.hasNext()) continue;
                this.current = this.sessionIterator.next();
                break;
            }
        }

        private void advance() {
            if (this.sessionIterator.hasNext()) {
                this.current = this.sessionIterator.next();
                return;
            }
            while (this.deviceIterator.hasNext()) {
                this.sessionIterator = this.deviceIterator.next().values().iterator();
                if (!this.sessionIterator.hasNext()) continue;
                this.current = this.sessionIterator.next();
                return;
            }
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public InetConnectionAutoRuntime next() {
            InetConnectionAutoRuntime current = this.current;
            this.advance();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

