/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.tariff.TariffModuleTree;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class MaxCalculator
extends MaxTrafficCalculator {
    protected String getModule() {
        return "ipn";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMaxServiceAmount(int contractId, Period period, String sids) {
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        long result = 0L;
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (Date)this.startMonth.getTime(), (int)this.moduleId);
            if (ServerUtils.tableExists((Connection)conSlave, (String)tableName)) {
                StringBuffer query = new StringBuffer(50);
                query.append("SELECT sid, SUM(amount) FROM ");
                query.append(tableName);
                query.append(" WHERE cid=? AND sid IN ( ");
                query.append(sids);
                query.append(")");
                if (period.getDateFrom() != null) {
                    query.append(" AND dt>='");
                    query.append(TimeUtils.formatSQLDate((Date)period.getDateFrom()));
                    query.append("'");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND dt<='");
                    query.append(TimeUtils.formatSQLDate((Date)period.getDateTo()));
                    query.append("'");
                }
                query.append(" GROUP BY sid");
                PreparedStatement ps = conSlave.prepareStatement(query.toString());
                ps.setInt(1, contractId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    if (rs.getLong(2) <= result) continue;
                    result = rs.getLong(2);
                }
                ps.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)conSlave);
        }
        return result;
    }

    protected void initTree(TariffModuleTree tree, int cid, Calendar time, int maxService, long amount) {
        TariffRequest request = new TariffRequest();
        request.setRequestParam("cid", (Object)cid);
        request.setRequestParam("time", (Object)time);
        request.setRequestParam("sid", (Object)maxService);
        request.setRequestParam("amount", (Object)amount);
        request.setRequestParam("action", (Object)"init");
        tree.processRequest(request);
    }
}

