/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusLogRecord;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class IPNContractStatusManager {
    private Connection con;
    private int mid;
    private Preferences moduleSetup = null;

    public IPNContractStatusManager(Connection con, int mid, Preferences moduleSetup) {
        this.con = con;
        this.mid = mid;
        this.moduleSetup = moduleSetup;
    }

    public int getContractStatus(int contractId) {
        int status = this.getDefaultContractStatus();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT status FROM ipn_contract_status_");
            query.append(this.mid);
            query.append(" WHERE cid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            rs = ps.executeQuery();
            if (rs.next()) {
                status = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    public int getDefaultContractStatus() {
        return this.moduleSetup.getInt("default.contract.status", 0);
    }

    @Deprecated
    public boolean statusExists(int contractId) {
        boolean result = false;
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT COUNT(status) FROM ipn_contract_status_");
            query.append(this.mid);
            query.append(" WHERE cid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public int changeStatus(int cid, int status_new, int userID, boolean updateManad) {
        int status = -1;
        String query = null;
        PreparedStatement ps = null;
        try {
            status = this.getContractStatus(cid);
            GateManager gm = new GateManager(this.con, this.mid);
            UserGateRuleManager ugrm = new UserGateRuleManager(this.con, this.mid);
            GateTypeManager gateTypeManager = new GateTypeManager(this.con, this.mid);
            RuleTypeManager ruleTypeManager = new RuleTypeManager(this.con, this.mid);
            List<UserGateRule> userRules = ugrm.getUserGateRules(cid);
            query = "INSERT INTO ipn_contract_status_log_" + this.mid + "( dt, cid, action, uid, comment ) VALUES ( now(), ?, ?, ?, ? )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, status_new);
            ps.setInt(3, userID);
            Map<Integer, GateType> gateTypeMap = gateTypeManager.getTypeMap();
            if (updateManad) {
                Map<Integer, RuleType> ruleTypeMap = ruleTypeManager.getTypeMap();
                for (UserGateRule rule : userRules) {
                    Gate gate = gm.getGateById(rule.getGateId());
                    if (gate == null) {
                        ps.setString(4, "\u041e\u0448\u0438\u0431\u043a\u0430!!! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u043b\u044e\u0437 \u0434\u043b\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u0430 " + rule.getId());
                        ps.executeUpdate();
                        continue;
                    }
                    GateType gateType = gateTypeMap.get(gate.getTypeId());
                    GateWorker gateWorker = (GateWorker)Utils.newInstance((String)gateType.getGateManager(), GateWorker.class);
                    if (gateWorker == null) {
                        ps.setString(4, "\u041e\u0448\u0438\u0431\u043a\u0430!!! \u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u0444\u0430\u0439\u0440\u0432\u043e\u043b\u0430 \u0434\u043b\u044f \u0448\u043b\u044e\u0437\u0430");
                        ps.executeUpdate();
                        continue;
                    }
                    RuleType ruleType = ruleTypeMap.get(rule.getRuleTypeId());
                    gate.setGateType(gateType);
                    Gate g = gate;
                    while (g.getParentId() > 0) {
                        Gate parentGate = gm.getGateById(g.getParentId());
                        g.setParent(parentGate);
                        parentGate.setGateType(gateTypeMap.get(parentGate.getTypeId()));
                        g = parentGate;
                    }
                    gateWorker.init(gate, ruleTypeMap, gateTypeMap, this.mid);
                    gateWorker.addUserStatus(cid, status_new, ruleType, gateType, rule, this.mid);
                    gateWorker.start();
                    Object gateErrors = "";
                    gateWorker.join();
                    gateErrors = (String)gateErrors + gateWorker.getGateErrors();
                    if (Utils.notBlankString((String)gateErrors)) {
                        ps.setString(4, (String)gateErrors);
                        ps.executeUpdate();
                        continue;
                    }
                    ps.setString(4, "\u0428\u043b\u044e\u0437: " + gate.getTitle());
                    ps.executeUpdate();
                }
            } else {
                ps.setString(4, "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
                ps.executeUpdate();
            }
            ps.close();
            this.createStatus(cid, status_new);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }

    public void searchIPNContractStatusLogRecordList(SearchResult<IPNContractStatusLogRecord> searchResult, int contractId, boolean dateSortOrder) {
        try {
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS * FROM ipn_contract_status_log_");
            query.append(this.mid);
            query.append(" WHERE cid=?");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND dt>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND dt<?");
                }
            }
            query.append(" ORDER BY dt");
            if (dateSortOrder) {
                query.append(" DESC");
            }
            if (page != null) {
                query.append(page.sqlLimit());
            }
            ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(index++, contractId);
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                IPNContractStatusLogRecord logRecord = new IPNContractStatusLogRecord();
                logRecord.setDate(rs.getTimestamp("dt"));
                logRecord.setStatusId(rs.getInt("action"));
                logRecord.setUserId(rs.getInt("uid"));
                logRecord.setComment(rs.getString("comment"));
                list.add(logRecord);
            }
            rs.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createStatus(int cid, int status) throws SQLException {
        String query = "REPLACE INTO ipn_contract_status_" + this.mid + " ( cid, status ) VALUES ( ?, ? )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setInt(2, status);
        ps.executeUpdate();
        ps.close();
    }

    public static String statusToString(int status) {
        String result = "???";
        switch (status) {
            case 0: {
                result = "\u043e\u0442\u043a\u0440\u044b\u0442";
                break;
            }
            case 1: {
                result = "\u0437\u0430\u043a\u0440\u044b\u0442";
                break;
            }
            case 2: {
                result = "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                break;
            }
            case 4: {
                result = "\u0436\u0435\u0441\u0442\u043a\u043e \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                break;
            }
            case 3: {
                result = "\u0443\u0434\u0430\u043b\u0435\u043d";
            }
        }
        return result;
    }
}

