/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Sorter<O, T, V extends Comparable<V>> {
    private List<O> listOne;
    private List<T> listTwo;
    private boolean ascending;
    private int i1 = 0;
    private int i2 = 0;

    public Sorter(List<O> listOne, List<T> listTwo, boolean ascending) {
        this.listOne = listOne;
        this.listTwo = listTwo;
        this.ascending = ascending;
    }

    public abstract V getFirstValue(O var1);

    public abstract V getSecondValue(T var1);

    public void sort() {
        Collections.sort(this.listOne, new Comparator<O>(){

            @Override
            public int compare(O o1, O o2) {
                return Sorter.this.getFirstValue(o1).compareTo(Sorter.this.getFirstValue(o2));
            }
        });
        Collections.sort(this.listTwo, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Sorter.this.getSecondValue(o1).compareTo(Sorter.this.getSecondValue(o2));
            }
        });
    }

    public boolean hasNext() {
        return this.i1 < this.listOne.size() || this.i2 < this.listTwo.size();
    }

    public Object getNext() {
        O two;
        O one = this.i1 < this.listOne.size() ? (O)this.listOne.get(this.i1) : null;
        O o = two = this.i2 < this.listTwo.size() ? (O)this.listTwo.get(this.i2) : null;
        if (one == null) {
            ++this.i2;
            return two;
        }
        if (two == null) {
            ++this.i1;
            return one;
        }
        int compare = this.getFirstValue(one).compareTo(this.getSecondValue(two));
        if (compare > 0) {
            O result = null;
            if (this.ascending) {
                result = two;
                ++this.i2;
            } else {
                result = one;
                ++this.i1;
            }
            return result;
        }
        if (compare < 0) {
            O result = null;
            if (!this.ascending) {
                result = two;
                ++this.i2;
            } else {
                result = one;
                ++this.i1;
            }
            return result;
        }
        ++this.i1;
        return one;
    }
}

