/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGSplitPane
extends JSplitPane {
    private boolean isDefaultDividerLocation = true;
    protected boolean modeDividerOnAdd = true;
    protected boolean saveDividerLocation = true;
    protected long defaultDividerLocation = 300L;

    public BGSplitPane() {
        this.setBorderAndDividerSize();
    }

    public BGSplitPane(int newOrientation) {
        super(newOrientation);
        this.setBorderAndDividerSize();
    }

    public BGSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.setBorderAndDividerSize();
    }

    public BGSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.setBorderAndDividerSize();
        this.setComponentListener(newLeftComponent);
    }

    public BGSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.setBorderAndDividerSize();
        this.setComponentListener(newLeftComponent);
    }

    private void setBorderAndDividerSize() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setDividerSize(5);
    }

    protected String getKey() {
        return ClientUtils.getComponentKey(this, "dividerLocation");
    }

    public void setDefaultDividerLocation(long defaultDividerLocation) {
        this.defaultDividerLocation = defaultDividerLocation;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.modeDividerOnAdd) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setDividerLocation();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BGSplitPane.this.setDividerLocation();
                    }
                });
            }
        }
    }

    protected void setDividerLocation() {
        int dividerLocation = ClientSetup.getInstance().getUserConfig().getInt(this.getKey(), -1);
        if (dividerLocation != -1) {
            this.setDividerLocation(Math.max(this.getMinimumDividerLocation(), dividerLocation));
            this.isDefaultDividerLocation = false;
        } else if (this.defaultDividerLocation > 0L) {
            this.setDividerLocation((int)Math.max((long)this.getMinimumDividerLocation(), this.defaultDividerLocation));
        } else if (this.defaultDividerLocation < 0L) {
            this.setDividerLocation((int)Math.max((long)this.getMinimumDividerLocation(), (long)this.getMaximumDividerLocation() + this.defaultDividerLocation));
        }
    }

    @Override
    public void setTopComponent(Component comp) {
        super.setTopComponent(comp);
        this.setComponentListener(comp);
    }

    @Override
    public void setLeftComponent(Component comp) {
        super.setLeftComponent(comp);
        this.setComponentListener(comp);
    }

    private void setComponentListener(Component comp) {
        if (comp != null) {
            for (ComponentListener l : comp.getComponentListeners()) {
                comp.removeComponentListener(l);
            }
            comp.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (BGSplitPane.this.saveDividerLocation) {
                        int dividerLocation = BGSplitPane.this.getDividerLocation();
                        if (e.getComponent().isShowing()) {
                            ClientSetup.getInstance().getUserConfig().set(BGSplitPane.this.getKey(), String.valueOf(dividerLocation));
                            BGSplitPane.this.isDefaultDividerLocation = false;
                        }
                    }
                }
            });
        }
    }

    public void setDefaultDividerLocation(double defaultDividerLocation) {
        if (this.isDefaultDividerLocation) {
            this.setDividerLocation(defaultDividerLocation);
        }
    }
}

