/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client.utils;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.loader.client.UtilPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ImportContractPanel
extends UtilPanel {
    public static final String TITLE = "\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432";
    public static final String CARD_NAME = "importContract";
    private final String[] texts = new String[]{"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0435\u0440", "\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c"};
    private JCheckBox contractClear = new JCheckBox("\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0431\u0430\u0437\u0443 \u043f\u0435\u0440\u0435\u0434 \u0438\u043c\u043f\u043e\u0440\u0442\u043e\u043c");
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel();
    private ContractPanel contractPanel = new ContractPanel();
    private ContractPatternPanel contractPatternPanel = new ContractPatternPanel();
    private BGUComboBox<IdTitle> fileCharset = new BGUComboBox();
    private BGUComboBox<IdTitle> fileFieldSeparator = new BGUComboBox();
    private ParameterTableModel parameterTableModel = new ParameterTableModel(ParameterTableModel.class.getName());

    @Override
    protected void jbInit() throws Exception {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)new UtilPanel.PanelTitleLabel(TITLE), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.getPanelClear(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getPanelInputFile(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.contractPatternPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.contractPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getPanelParamMap(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getPanelClear() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.contractClear, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPanelInputFile() {
        this.fileFieldSeparator.setData(Arrays.asList(new IdTitle(0, "\u0422\u0410\u0412"), new IdTitle(1, ";"), new IdTitle(2, ",")));
        this.fileCharset.setData(Arrays.asList(new IdTitle(0, "UTF-8"), new IdTitle(1, "Cp1251")));
        this.fileCharset.addActionListener(e -> {
            if (this.selectFilePanel.getSelectedFile() != null) {
                this.selectedImportFile((IdTitle)this.fileCharset.getSelectedItem());
            }
        });
        this.selectFilePanel.setDialogTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        this.selectFilePanel.setShowPath(true);
        this.selectFilePanel.setFileFieldBackground(new JTextField().getBackground());
        this.selectFilePanel.setFileFilter("csv", "Text CSV");
        this.selectFilePanel.addPropertyChangeListener(e -> {
            if ("fileSelected".equals(e.getPropertyName())) {
                this.selectedImportFile((IdTitle)this.fileCharset.getSelectedItem());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0424\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438"));
        panel.add((Component)this.selectFilePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.fileCharset, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.fileFieldSeparator, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPanelParamMap() {
        final BGUTable table = new BGUTable(this.parameterTableModel);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                List<ParameterRowData> parameterRowDataList = ImportContractPanel.this.parameterTableModel.getSelectedRows();
                if (mouseEvent.getClickCount() == 2 && !parameterRowDataList.isEmpty()) {
                    ImportContractPanel.this.setParameterValue(parameterRowDataList);
                    table.repaint();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440").addActionListener(e -> {
                        ImportContractPanel.this.setParameterValue(parameterRowDataList);
                        table.invalidate();
                        table.repaint();
                    });
                    popupMenu.show(table, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u041c\u0430\u043f\u0438\u043d\u0433 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432"));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setParameterValue(List<ParameterRowData> parameterRowDataList) {
        IdTitle idTitle2;
        ArrayList<IdTitle> parameterItems = new ArrayList<IdTitle>();
        parameterItems.add(new IdTitle(-2, this.texts[0]));
        parameterItems.add(new IdTitle(-1, this.texts[1]));
        parameterItems.add(new IdTitle(0, this.texts[2]));
        this.getContractParameterList(this.getContractParameterTypes()).forEach(idTitle -> parameterItems.add((IdTitle)idTitle));
        BGUComboBox<IdTitle> parameterComboBox = new BGUComboBox<IdTitle>();
        parameterComboBox.setData(parameterItems);
        if (parameterRowDataList.size() == 1) {
            int paramId = parameterRowDataList.get(0).getParameterId();
            for (int index = 0; index < parameterComboBox.getItemCount(); ++index) {
                if (((IdTitle)parameterComboBox.getItemAt(index)).getId() != paramId) continue;
                parameterComboBox.setSelectedIndex(index);
                break;
            }
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043b\u044f " + (String)(parameterRowDataList.size() == 1 ? "\u043a\u043e\u043b\u043e\u043d\u043a\u0438 - " + parameterRowDataList.get(0).getFileParamKey() : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043b\u043e\u043d\u043e\u043a")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add(parameterComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 5, 5), 0, 0));
        int optionId = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), panel, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 2);
        if (optionId == 0 && (idTitle2 = (IdTitle)parameterComboBox.getSelectedItem()) != null) {
            for (ParameterRowData parameterRowData : parameterRowDataList) {
                parameterRowData.setParameterId(idTitle2.getId());
            }
        }
    }

    private void selectedImportFile(IdTitle fileCharset) {
        File file = this.selectFilePanel.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
            return;
        }
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file, Charset.forName(fileCharset.getTitle())));
            String line = null;
            while (reader.ready()) {
                line = reader.readLine();
                if (line == null) continue;
                lines.add(line);
                if (lines.size() <= 1) continue;
            }
            reader.close();
            if (lines.size() > 0) {
                this.parse(((String)lines.get(0)).toCharArray(), headers);
            }
            if (lines.size() > 1) {
                this.parse(((String)lines.get(1)).toCharArray(), values);
            }
            if (values.size() != headers.size()) {
                ClientUtils.showErrorMessageDialog(String.format("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043b\u0435\u0439 \u0432 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0435(%s) \u0438 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445(%s) \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442", headers.size(), values.size()));
                return;
            }
            String CONTRACT_TITLE = "contractTitle";
            this.contractPanel.contractTitleImportField.removeAllItems();
            IdTitle contractTitleIdTitle = new IdTitle(0, "contractTitle");
            headers.forEach(header -> this.contractPanel.contractTitleImportField.addItem("contractTitle".equals(header) ? contractTitleIdTitle : new IdTitle(this.contractPanel.contractTitleImportField.getItemCount() + 1, (String)header)));
            this.contractPanel.contractTitleImportField.setSelectedItem(contractTitleIdTitle);
            String CONTRACT_DATE = "contractDate";
            this.contractPanel.contractDateImportField.removeAllItems();
            IdTitle contractDateIdTitle = new IdTitle(0, "contractDate");
            headers.forEach(header -> this.contractPanel.contractDateImportField.addItem("contractDate".equals(header) ? contractDateIdTitle : new IdTitle(this.contractPanel.contractDateImportField.getItemCount() + 1, (String)header)));
            this.contractPanel.contractDateImportField.setSelectedItem(contractDateIdTitle);
            String CONTRACT_PASSWORD = "contractPassword";
            this.contractPanel.contractPasswordImportField.removeAllItems();
            IdTitle contractPasswordIdTitle = new IdTitle(0, "contractPassword");
            headers.forEach(header -> this.contractPanel.contractPasswordImportField.addItem("contractPassword".equals(header) ? contractPasswordIdTitle : new IdTitle(this.contractPanel.contractPasswordImportField.getItemCount() + 1, (String)header)));
            this.contractPanel.contractPasswordImportField.setSelectedItem(contractPasswordIdTitle);
            this.parameterTableModel.deleteRows();
            ArrayList<ParameterRowData> rows = new ArrayList<ParameterRowData>();
            for (int index = 0; index < headers.size(); ++index) {
                String header2 = (String)headers.get(index);
                if (!header2.startsWith("parameter")) continue;
                int parameterId = Utils.parseInt(header2.substring(10));
                Optional<ContractParameterGroupAttr> optional = this.getContractParameterList(this.getContractParameterTypes()).stream().filter(i -> i.getId() == parameterId).findFirst();
                rows.add(new ParameterRowData(header2, (String)values.get(index), optional.isPresent() ? optional.get().getId() : -2));
            }
            this.parameterTableModel.setData(rows);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412 \u0444\u0430\u0439\u043b\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432 - " + headers.size(), "Ok", 1);
    }

    protected int[] getContractParameterTypes() {
        return new int[]{EntitySpecAttrType.TEXT.getCode(), EntitySpecAttrType.DATE.getCode(), EntitySpecAttrType.BOOLEAN.getCode(), EntitySpecAttrType.EMAIL.getCode(), EntitySpecAttrType.ADDRESS.getCode()};
    }

    private void parse(char[] data, List<String> values) {
        int pos1 = 0;
        int pos2 = 0;
        char separator = switch (((IdTitle)this.fileFieldSeparator.getSelectedItem()).getId()) {
            case 0 -> '\t';
            case 1 -> ';';
            case 2 -> ',';
            default -> throw new IllegalArgumentException("Unexpected value: " + ((IdTitle)this.fileFieldSeparator.getSelectedItem()).getId());
        };
        while (pos2 < data.length) {
            char c = data[pos2];
            if (c == '\"') {
                ++pos2;
                while (pos2 < data.length) {
                    c = data[pos2];
                    if (c != '\"') {
                        ++pos2;
                        continue;
                    }
                    if (pos2 != data.length - 1) {
                        c = data[pos2 + 1];
                        if (c != '\"') {
                            ++pos2;
                            break;
                        }
                        pos2 += 2;
                        continue;
                    }
                    ++pos2;
                }
            } else {
                while (pos2 < data.length && (c = data[pos2]) != separator) {
                    ++pos2;
                }
            }
            values.add(new String(Arrays.copyOfRange(data, data[pos1] == '\"' ? pos1 + 1 : pos1, data[pos2 - 1] == '\"' ? pos2 - 1 : pos2)).replace("\"\"", "\""));
            pos1 = ++pos2;
        }
    }

    @Override
    protected void doUtil() {
        JSONObject config = new JSONObject();
        JSONArray configContractParams = new JSONArray();
        for (ParameterRowData parameterRowData : this.parameterTableModel.getRows()) {
            if (parameterRowData.getParameterId() == -2) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0434\u043b\u044f \u043a\u043e\u043b\u043e\u043d\u043a\u0438 - " + parameterRowData.fileParamKey);
                return;
            }
            JSONObject configContractParam = new JSONObject();
            configContractParam.put("name", (Object)parameterRowData.getFileParamKey());
            configContractParam.put("value", parameterRowData.parameterId);
            configContractParams.put((Object)configContractParam);
        }
        config.put("contractParams", (Object)configContractParams);
        config.put("fieldSeparator", (Object)String.valueOf(switch (((IdTitle)this.fileFieldSeparator.getSelectedItem()).getId()) {
            case 0 -> '\t';
            case 1 -> ';';
            case 2 -> ',';
            default -> throw new IllegalArgumentException("Unexpected value: " + ((IdTitle)this.fileFieldSeparator.getSelectedItem()).getId());
        }));
        JSONObject configContractTitle = new JSONObject();
        if (this.contractPanel.titleButton1.isSelected()) {
            configContractTitle.put("pattern", true);
        } else if (this.contractPanel.titleButton2.isSelected()) {
            configContractTitle.put("field", (Object)this.contractPanel.contractTitleImportField.getSelectedItem().getTitle());
        }
        config.put("contractTitle", (Object)configContractTitle);
        JSONObject configContractDate = new JSONObject();
        if (this.contractPanel.dateButton1.isSelected()) {
            configContractDate.put("now", true);
        } else if (this.contractPanel.dateButton2.isSelected()) {
            configContractDate.put("field", (Object)this.contractPanel.contractDateImportField.getSelectedItem().getTitle());
            configContractDate.put("fieldPattern", (Object)this.contractPanel.contractPatternDateImportField.getSelectedItem().getTitle());
        }
        config.put("contractDate", (Object)configContractDate);
        JSONObject configContractPassword = new JSONObject();
        if (this.contractPanel.passwordButton1.isSelected()) {
            configContractPassword.put("auto", true);
        } else if (this.contractPanel.passwordButton2.isSelected()) {
            configContractPassword.put("field", (Object)this.contractPanel.contractPasswordImportField.getSelectedItem().getTitle());
        }
        config.put("contractPassword", (Object)configContractPassword);
        JSONObject configContractPattern = new JSONObject();
        if (this.contractPatternPanel.button1.isSelected()) {
            configContractPattern.put("fieldContractPatternId", true);
        } else if (this.contractPatternPanel.button2.isSelected()) {
            configContractPattern.put("contractPatternId", ((IdTitle)this.contractPatternPanel.contractPatterns.getSelectedItem()).getId());
        }
        config.put("contractPattern", (Object)configContractPattern);
        JSONObject configContractClear = new JSONObject();
        configContractClear.put("value", this.contractClear.isSelected());
        config.put("contractClear", (Object)configContractClear);
        try {
            String result = this.getLoaderService().doUtil("ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderImportContractUtil", new String(this.getDataFromFile(this.selectFilePanel.getSelectedFile()), ((IdTitle)this.fileCharset.getSelectedItem()).getTitle()), config.toString());
            if (result != null && !result.isEmpty()) {
                ClientUtils.showMessageDialog(result);
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    protected void doClearForm() {
        this.parameterTableModel.deleteRows();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.contractPatternPanel.contractPatterns.setData(this.getLoaderService().getContractPatternList()));
    }

    class ContractPanel
    extends JPanel {
        ButtonGroup titleButtonGroup;
        JRadioButton titleButton1;
        JRadioButton titleButton2;
        BGComboBox<IdTitle> contractTitleImportField;
        ButtonGroup dateButtonGroup;
        JRadioButton dateButton1;
        JRadioButton dateButton2;
        BGComboBox<IdTitle> contractDateImportField;
        BGComboBox<IdTitle> contractPatternDateImportField;
        ButtonGroup passwordButtonGroup;
        JRadioButton passwordButton1;
        JRadioButton passwordButton2;
        BGComboBox<IdTitle> contractPasswordImportField;

        ContractPanel() {
            super(new GridBagLayout());
            this.titleButtonGroup = new ButtonGroup();
            this.titleButton1 = new JRadioButton("\u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
            this.titleButton2 = new JRadioButton("\u0438\u0437 \u043a\u043e\u043b\u043e\u043d\u043a\u0438 -> ");
            this.contractTitleImportField = new BGComboBox();
            this.dateButtonGroup = new ButtonGroup();
            this.dateButton1 = new JRadioButton("\u0442\u0435\u043a\u0443\u0449\u0430\u044f");
            this.dateButton2 = new JRadioButton("\u0438\u0437 \u043a\u043e\u043b\u043e\u043d\u043a\u0438 -> ");
            this.contractDateImportField = new BGComboBox();
            this.contractPatternDateImportField = new BGComboBox();
            this.passwordButtonGroup = new ButtonGroup();
            this.passwordButton1 = new JRadioButton("\u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439");
            this.passwordButton2 = new JRadioButton("\u0438\u0437 \u043a\u043e\u043b\u043e\u043d\u043a\u0438 -> ");
            this.contractPasswordImportField = new BGComboBox();
            this.titleButton1.setSelected(true);
            this.dateButton1.setSelected(true);
            this.passwordButton1.setSelected(true);
            this.titleButtonGroup.add(this.titleButton1);
            this.titleButtonGroup.add(this.titleButton2);
            this.dateButtonGroup.add(this.dateButton1);
            this.dateButtonGroup.add(this.dateButton2);
            this.passwordButtonGroup.add(this.passwordButton1);
            this.passwordButtonGroup.add(this.passwordButton2);
            this.contractPatternDateImportField.addItem(new IdTitle(1, "dd.MM.yyyy"));
            this.contractPatternDateImportField.addItem(new IdTitle(2, "yyyy-MM-dd"));
            int gridx = 0;
            JPanel contractTitlePanel = new JPanel(new GridBagLayout());
            contractTitlePanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            contractTitlePanel.add((Component)this.titleButton1, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractTitlePanel.add((Component)this.titleButton2, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractTitlePanel.add(this.contractTitleImportField, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel contractDatePanel = new JPanel(new GridBagLayout());
            contractDatePanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            contractDatePanel.add((Component)this.dateButton1, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractDatePanel.add((Component)this.dateButton2, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractDatePanel.add(this.contractDateImportField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractDatePanel.add(this.contractPatternDateImportField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel contractPasswordPanel = new JPanel(new GridBagLayout());
            contractPasswordPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            contractPasswordPanel.add((Component)this.passwordButton1, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractPasswordPanel.add((Component)this.passwordButton2, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            contractPasswordPanel.add(this.contractPasswordImportField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setBorder(new BGTitleBorder("\u0414\u043e\u0433\u043e\u0432\u043e\u0440"));
            this.add((Component)contractTitlePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)contractDatePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)contractPasswordPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        }
    }

    class ContractPatternPanel
    extends JPanel {
        ButtonGroup buttonGroup;
        JRadioButton button1;
        JRadioButton button2;
        BGUComboBox<IdTitle> contractPatterns;

        ContractPatternPanel() {
            super(new GridBagLayout());
            this.buttonGroup = new ButtonGroup();
            this.button1 = new JRadioButton("\u0448\u0430\u0431\u043b\u043e\u043d \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 (\u0441\u0442\u043e\u043b\u0431\u0435\u0446 contractPatternId)");
            this.button2 = new JRadioButton("\u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0448\u0430\u0431\u043b\u043e\u043d -> ");
            this.contractPatterns = new BGUComboBox();
            this.button1.setSelected(true);
            this.buttonGroup.add(this.button1);
            this.buttonGroup.add(this.button2);
            JPanel button2Panel = new JPanel(new GridBagLayout());
            button2Panel.add((Component)this.button2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            button2Panel.add(this.contractPatterns, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            int gridy = 0;
            this.setBorder(new BGTitleBorder("\u0428\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
            this.add((Component)this.button1, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)button2Panel, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        }
    }

    class ParameterTableModel
    extends BGTableModel<ParameterRowData> {
        public ParameterTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u043e\u043b\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435", 200, 400, 500, "fileParamKey", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435", 200, 400, 500, "fileParamValue", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 200, 300, -1, "paramTitle", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(ParameterRowData parameterRowData, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("paramTitle".equals(identifier)) {
                int paramId = parameterRowData.getParameterId();
                if (paramId == -2) {
                    return ImportContractPanel.this.texts[0];
                }
                if (paramId == -1) {
                    return ImportContractPanel.this.texts[1];
                }
                if (paramId == 0) {
                    return ImportContractPanel.this.texts[2];
                }
                Optional<ContractParameterGroupAttr> optional = ImportContractPanel.this.getContractParameterList(ImportContractPanel.this.getContractParameterTypes()).stream().filter(i -> i.getId() == paramId).findFirst();
                return optional.isPresent() ? optional.get().getTitle() : String.valueOf(paramId);
            }
            return super.getValue(parameterRowData, column);
        }
    }

    public class ParameterRowData {
        private String fileParamKey;
        private String fileParamValue;
        private String paramTitle;
        private int parameterId = -2;

        ParameterRowData(String fileParamKey, String fileParamValue, int parameterId) {
            this.fileParamKey = fileParamKey;
            this.fileParamValue = fileParamValue;
            this.parameterId = parameterId;
        }

        public String getFileParamKey() {
            return this.fileParamKey;
        }

        public String getFileParamValue() {
            return this.fileParamValue;
        }

        public String getParamTitle() {
            return this.paramTitle;
        }

        public int getParameterId() {
            return this.parameterId;
        }

        public void setParameterId(int parameterId) {
            this.parameterId = parameterId;
        }
    }
}

