/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.sms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.Utils;

public class SmsAgent {
    private static final Logger logger = LogManager.getLogger((String)SmsAgent.class.getSimpleName());
    private final String login;
    private final String password;

    public SmsAgent(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void sendMessage(String phone, String message, String from) throws BGException {
        this.sendMessage(Collections.singletonList(phone), message, from);
    }

    public void sendMessage(List<String> phones, String messageText, String from) throws BGException {
        this.checkValidData(phones, messageText);
        try {
            HttpRequest request = HttpRequest.newBuilder(this.buildUri(phones, messageText, from)).GET().build();
            logger.info("Request to SmsAgent >>> " + request.toString());
            String responseText = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build().send(request, HttpResponse.BodyHandlers.ofString()).body();
            logger.info("Response from SmsAgent >>> " + responseText);
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new BGException(e);
        }
    }

    private void checkValidData(List<String> phones, String messageText) throws BGIllegalArgumentException {
        if (Utils.isBlankString(this.login) || Utils.isBlankString(this.password)) {
            throw new BGIllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c");
        }
        if (Utils.isEmptyCollection(phones)) {
            throw new BGIllegalArgumentException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f");
        }
        if (Utils.isBlankString(messageText)) {
            throw new BGIllegalArgumentException("\u0422\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043f\u0443\u0441\u0442\u043e\u0439!");
        }
    }

    private URI buildUri(List<String> phones, String text, String from) throws URISyntaxException {
        StringBuilder urlBuilder = new StringBuilder("https://api3.sms-agent.ru/v2.0/");
        urlBuilder.append("?login=").append(this.login).append("&pass=").append(this.password).append("&act=").append("send").append("&to=").append(Utils.toString(phones, ","));
        if (Utils.notBlankString(from)) {
            urlBuilder.append("&from=").append(from);
        }
        urlBuilder.append("&text=").append(URLEncoder.encode(text, StandardCharsets.UTF_8));
        logger.debug("Send sms message to SmsAgent >>> " + urlBuilder.toString());
        return URI.create(urlBuilder.toString());
    }
}

