/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;

public class CostAdditionTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon("coins_wrench");
    private JLabel view = new JLabel();
    private BGComboBox<ComboBoxItem> comboSign;
    private BGComboBox<ComboBoxItem> comboWhat;
    private FloatTextField cost = new FloatTextField();

    public CostAdditionTariffTreeNode() {
        this.view.setIcon(icon);
    }

    @Override
    protected JPanel getEditorPanel() {
        this.comboSign = new BGComboBox();
        this.comboWhat = new BGComboBox();
        this.comboSign.addItem(new ComboBoxItem("+", "+"));
        this.comboSign.addItem(new ComboBoxItem("-", "-"));
        this.comboSign.setSelectedIndex(0);
        this.comboWhat.addItem(new ComboBoxItem("1", "\u0437\u0430 \u043c\u0438\u043d\u0443\u0442\u0443"));
        this.comboWhat.addItem(new ComboBoxItem("2", "\u0437\u0430 \u0441\u0435\u0441\u0441\u0438\u044e"));
        JPanel propsPanel = new JPanel();
        propsPanel.add(this.comboSign);
        propsPanel.add(this.cost);
        propsPanel.add(this.comboWhat);
        return propsPanel;
    }

    @Override
    public Component getView() {
        Map<String, String> data = this.getDataInHash();
        StringBuilder labelText = new StringBuilder().append("<html>").append("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438: ");
        String val = data.get("operation");
        labelText.append(val != null ? val : "+");
        val = data.get("value");
        labelText.append(val != null ? val : "0.00");
        String subject = "1".equals(data.get("subject")) ? "\u0437\u0430 \u043c\u0438\u043d\u0443\u0442\u0443" : "\u0437\u0430 \u0441\u0435\u0441\u0441\u0438\u044e";
        labelText.append(" ").append(subject);
        labelText.append("</html>");
        this.view.setText(labelText.toString());
        return this.view;
    }

    @Override
    protected void loadData() {
        Map<String, String> map = this.getDataInHash();
        this.cost.setText(map.get("value"));
        this.comboSign.setSelectedId(map.get("operation"));
        this.comboWhat.setSelectedId(map.get("subject"));
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", this.cost.getText());
        map.put("operation", this.comboSign.getSelectedId());
        map.put("subject", this.comboWhat.getSelectedId());
        this.setDataInHash(map);
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        this.serializeHashToXML(el);
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", el.getAttribute("value"));
        map.put("operation", el.getAttribute("operation"));
        map.put("subject", el.getAttribute("subject"));
        this.setDataInHash(map);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

