/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.NewPermanentOrder;
import ru.bitel.bgbilling.modules.license.common.bean.NewTestOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderBillData;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.common.service.OrderService;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.mail.MailOrderCreate;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.license.common.service.OrderService")
public class OrderServiceImpl
extends AbstractService
implements OrderService {
    LicenseManager manager;

    @PostConstruct
    void init() {
        this.manager = new LicenseManager(this.getConnection(), this.moduleId);
    }

    public List<Order> getOrders(int copyId, String testFilter, String permanentFilter, int componentFilter) throws BGException {
        List filterPermanentStatus = Utils.toIntegerList((String)permanentFilter);
        List filterTestStatus = Utils.toIntegerList((String)testFilter);
        if (copyId <= 0) {
            throw new BGIllegalArgumentException();
        }
        String permanentFS = Utils.toString((List)filterPermanentStatus, (int)0);
        permanentFS = permanentFS.replaceAll(",0", "");
        String testFS = Utils.toString((List)filterTestStatus, (int)0);
        testFS.replaceAll(",0", "");
        List<Order> list = null;
        if (!Utils.isBlankString((String)testFS) || !Utils.isBlankString((String)permanentFS)) {
            list = this.manager.getOrders(copyId, permanentFS, testFS, componentFilter);
            for (Order order : list) {
                if (order.getUserId() != 0) continue;
                order.setUserName("-");
            }
        }
        return list;
    }

    public List<Order> getOrdersList(int copyId, int type, int status, int componentId) throws BGException {
        return this.manager.getOrders(copyId, Stream.of(OrderType.getOrderTypeByCode((int)type)).toList(), Stream.of(Integer.valueOf(status)).toList(), componentId);
    }

    public List<Component> getComponentItems(int copyId, boolean showHidden, boolean customer) throws BGException {
        if (copyId < 0) {
            return this.manager.getComponentList();
        }
        return this.manager.getComponentList(copyId, showHidden, customer ? Boolean.valueOf(true) : null);
    }

    public BigDecimal getCostComponent(String componentName, int count, int copyId) throws BGException {
        Copy copy = this.manager.getCopy(copyId);
        String productVersion = copy.getProductVersion();
        float floatCost = LicenseUtils.getCost(LicenseUtils.buildLicenseCostUrlRequest(componentName, count, productVersion, (Preferences)Setup.getSetup()), null);
        return new BigDecimal(Float.toString(floatCost));
    }

    public Integer getCountOrderedComponents(String componentName, int copyId) throws BGException {
        List<Order> listOrder = this.manager.getOrders(copyId, "2", null, -1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Collections.reverse(listOrder);
        for (Order order : listOrder) {
            String name = order.getComponentName();
            if (!componentName.equals(name)) continue;
            if (map.containsKey(name)) {
                if (order.getCount() == 0) {
                    map.put(name, 0);
                    continue;
                }
                if ((Integer)map.get(name) == 0) {
                    return null;
                }
                map.put(name, order.getCount() + (Integer)map.get(name));
                continue;
            }
            map.put(order.getComponentName(), order.getCount());
        }
        return map.get(componentName) == null ? -1 : (Integer)map.get(componentName);
    }

    public List<NewPermanentOrder> getNewPermanentOrders(int copyId) throws BGException {
        return this.convertPermanent(this.manager.getOrders(copyId, "0", null, -1), copyId);
    }

    public List<NewTestOrder> getNewTestOrders(int copyId) throws BGException {
        return this.convertTest(this.manager.getOrders(copyId, null, "0", -1), copyId);
    }

    private List<NewPermanentOrder> convertPermanent(List<Order> orders, int copyId) throws BGException {
        if (orders == null) {
            return null;
        }
        ArrayList<NewPermanentOrder> result = new ArrayList<NewPermanentOrder>();
        int number = 1;
        for (Order component : orders) {
            int presentCount = this.getCountOrderedComponents(component.getComponentName(), copyId);
            BigDecimal presentSum = presentCount > -1 ? this.getCostComponent(component.getComponentName(), presentCount, copyId) : BigDecimal.ZERO;
            NewPermanentOrder order = new NewPermanentOrder(component.getComponentId(), component.getComponentName(), presentCount, presentSum, this.isComponenetUnlimit(component.getComponentId(), copyId), copyId);
            order.setId(component.getId());
            order.setCount(component.getCount());
            order.setNumber(number++);
            if (order.getCount() == 0) {
                order.setTotalCount(Integer.valueOf(0));
            } else {
                order.setTotalCount(Integer.valueOf(order.getPresentCount() == -1 ? order.getCount() : order.getCount() + order.getPresentCount()));
            }
            BigDecimal totalCost = order.getTotalCount() > -1 ? this.getCostComponent(order.getComponentName(), order.getTotalCount(), copyId) : BigDecimal.ZERO;
            order.setTotalSum(totalCost.setScale(2, RoundingMode.CEILING));
            if (order.getCount() == 0) {
                order.setUnlimited(true);
            }
            result.add(order);
        }
        return result;
    }

    private List<NewTestOrder> convertTest(List<Order> orders, int copyId) throws BGException {
        ArrayList<NewTestOrder> result = new ArrayList<NewTestOrder>();
        int number = 1;
        for (Order component : orders) {
            NewTestOrder order = new NewTestOrder(component.getComponentId(), component.getComponentName(), this.isComponenetUnlimit(component.getComponentId(), copyId), copyId);
            order.setId(component.getId());
            order.setCount(component.getCount());
            if (order.getCount() == 0) {
                order.setUnlimited(true);
            }
            order.setNumber(number++);
            order.setTerm(component.getTerm());
            order.setToDate(TimeUtils.nowPlusPeriod((int)5, (int)component.getTerm()));
            result.add(order);
        }
        return result;
    }

    private boolean isComponenetUnlimit(int componentId, int copyId) throws BGException {
        for (Component component : this.getComponentItems(copyId, false, false)) {
            if (component.getId() != componentId) continue;
            return component.getUnlimited() == 1;
        }
        return false;
    }

    public int orderCreate(int contractId, Order order, boolean customer) throws BGException {
        if (order.getType().getCode() < 0) {
            throw new BGIllegalArgumentException("order.type");
        }
        if (order.getCount() < 0) {
            throw new BGIllegalArgumentException("order.count");
        }
        if (order.getType() == OrderType.TEST && order.getTerm() <= 0) {
            throw new BGMessageException("\u0421\u0440\u043e\u043a \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u0432\u0435\u0440\u043d\u043e!", "order.term");
        }
        Copy copy = this.manager.getCopy(order.getCopyId());
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("order.copyId");
        }
        if (order.getType() == OrderType.BUY && this.manager.checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
            throw new BGMessageException("\u0417\u0430\u043a\u0430\u0437 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d! \\n\u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c( \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 ), \u0430 \u0435\u0441\u043b\u0438 \u0432\u044b \u0435\u0433\u043e \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0442\u0438\u043b\u0438, \u0442\u043e \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043d\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u0435 \u043d\u0430\u043c \u0435\u0433\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c.", "order.create.agreementError");
        }
        this.manager.updateCopyItemOrder(order);
        order = this.manager.getOrder(order.getId());
        if (customer && order != null && order.getType() == OrderType.TEST) {
            MailMsg message = new MailMsg((Preferences)this.getSetup());
            String recipient = this.getModuleSetup().get("license.bills.email.to", "");
            if (Utils.notBlankString((String)recipient)) {
                ContractUtils cu = new ContractUtils(this.getConnection());
                String text = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(contractId, false) + " \u0434\u043e\u0431\u0430\u0432\u0438\u043b \u0437\u0430\u043a\u0430\u0437 \u043d\u0430 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \n" + order.getComponentName() + " \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 " + OrderUtils.getCount((Integer)order.getCount()) + " \u043d\u0430 \u0441\u0440\u043e\u043a " + order.getTerm() + " \u0434\u043d\u0435\u0439.";
                try {
                    MailOrderCreate mailData = new MailOrderCreate();
                    mailData.setModuleId(this.moduleId);
                    mailData.setRecipients(recipient);
                    mailData.setSubject("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430");
                    mailData.addTextPart("text", text);
                    message.sendMessage((MailData)mailData);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            } else {
                this.getLogger().error("Wrong license.bills.email.to value. Can't send email.");
            }
        }
        return order.getId();
    }

    public void ordersCopy(int contractId, int copyId, Set<Integer> orderIds, int term) throws BGException {
        if (orderIds == null || orderIds.size() == 0) {
            throw new BGIllegalArgumentException("orderIds");
        }
        if (term <= 0) {
            throw new BGIllegalArgumentException("term");
        }
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Copy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        for (Integer orderId : orderIds) {
            Order order = licenseManager.getOrder(orderId);
            if (order == null) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (copy.getId() != order.getCopyId()) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getType() != OrderType.BUY) {
                throw new BGMessageException("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\" \u0438 \u0442\u0438\u043f\u043e\u043c \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439\".", "orderIds.type.notBuy");
            }
            if (order.getStatus() != 0) {
                throw new BGMessageException("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\" \u0438 \u0442\u0438\u043f\u043e\u043c \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439\".", "orderIds.status.notNew");
            }
            orderList.add(order);
        }
        for (Order order : orderList) {
            ConfirmedOrder grouppedItems = licenseManager.groupCopyItems(order.getComponentId(), order.getCopyId(), new int[]{2, 0});
            licenseManager.createTestCopiesForOrder(order, term, grouppedItems.getCount());
        }
    }

    public List<OrderBillData> ordersBillDataList(int contractId, int copyId, Set<Integer> orderIds) throws BGException {
        if (orderIds == null || orderIds.size() == 0) {
            throw new BGIllegalArgumentException("orderIds");
        }
        ArrayList<OrderBillData> result = new ArrayList<OrderBillData>();
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Copy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        for (Integer orderId : orderIds) {
            Order order = licenseManager.getOrder(orderId);
            if (order == null) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (copy.getId() != order.getCopyId()) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getType() == OrderType.TEST) {
                throw new BGMessageException("\u0421\u0447\u0435\u0442 \u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441 \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0439\" \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0435\u0439.", "orderIds.type.notBuy");
            }
            orderList.add(order);
        }
        String productVersion = copy.getProductVersion();
        HashSet<Integer> processedComponentIds = new HashSet<Integer>();
        for (Order order : orderList) {
            int componentId = order.getComponentId();
            if (!processedComponentIds.add(componentId)) continue;
            ConfirmedOrder grouppedConfirmedItem = licenseManager.groupCopyItems(componentId, copy.getId(), new int[]{2, 3});
            ConfirmedOrder grouppedNewItem = licenseManager.groupCopyItems(componentId, copy.getId(), new int[]{0});
            if (grouppedConfirmedItem == null && grouppedNewItem == null) continue;
            String productItemName = new String();
            Integer confirmedItemsCount = null;
            if (grouppedConfirmedItem != null) {
                confirmedItemsCount = grouppedConfirmedItem.getCount();
                productItemName = grouppedConfirmedItem.getComponentName();
            }
            Integer newItemsCount = null;
            if (grouppedNewItem != null) {
                newItemsCount = grouppedNewItem.getCount();
                productItemName = grouppedNewItem.getComponentName();
            }
            OrderBillData orderBillData = LicenseUtils.getCostDelta(productItemName, confirmedItemsCount, newItemsCount, productVersion, (Preferences)this.getModuleSetup());
            orderBillData.setComponentId(order.getComponentId());
            orderBillData.setComponentTitle(order.getComponentTitle());
            result.add(orderBillData);
        }
        return result;
    }

    public void ordersDelete(int contractId, int copyId, Set<Integer> orderIds) throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        Copy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        boolean haveNonSign = licenseManager.checkHaveNonSignAdditionalAgreement(copyId);
        for (Integer orderId : orderIds) {
            Order order = licenseManager.getOrder(orderId);
            if (order == null || order.getCopyId() != copyId) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getStatus() != 0) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\".", "orderIds.status.notNew");
            }
            if (!haveNonSign || order.getType() != OrderType.BUY) continue;
            throw new BGMessageException("\u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c (\u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442).", "orderIds.agreement.notSign");
        }
        for (Integer orderId : orderIds) {
            licenseManager.deleteOrder(orderId);
        }
    }
}

