/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public class CallCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JLabel view = new JLabel(icon, 2);
    private BGComboBox<ComboBoxItem> costTypeCombo;
    private BGComboBox<ComboBoxItem> costSourceCombo;
    private FloatTextField cost;
    private JCheckBox defaultPrice;
    private String costValue;
    private boolean isDefault;
    private String costSource;
    private String costType;

    protected void loadData() {
        this.extractData();
        this.cost.setText(this.costValue);
        this.defaultPrice.setSelected(this.isDefault);
        ClientUtils.setComboBoxSelection(this.costTypeCombo, (Object)this.costType);
        ClientUtils.setComboBoxSelection(this.costSourceCombo, (Object)this.costSource);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.costValue = (String)data.get("cost");
        if (this.costValue == null) {
            this.costValue = "";
        }
        this.isDefault = data.get("default") != null;
        this.costType = (String)data.get("cost_type");
        if (Utils.isBlankString((String)this.costType)) {
            this.costType = "min";
        }
        this.costSource = (String)data.get("cost_source");
        if (Utils.isBlankString((String)this.costSource)) {
            this.costSource = "node";
        }
        if (data.size() == 0) {
            this.costValue = this.getData();
            this.isDefault = false;
            this.costType = "min";
            this.costSource = "node";
        }
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("cost", this.cost.getText());
        if (this.defaultPrice.isSelected()) {
            data.put("default", "true");
        }
        data.put("cost_type", ClientUtils.getIdFromComboBox(this.costTypeCombo));
        data.put("cost_source", ClientUtils.getIdFromComboBox(this.costSourceCombo));
        this.setDataInHash(data);
    }

    public void loadFromXML(Element element) {
        this.loadHashFromXML(element);
    }

    public void serializeToXML(Element element) {
        this.serializeHashToXML(element);
    }

    protected JPanel getEditorPanel() {
        JPanel propsPanel = new JPanel();
        if (this.costTypeCombo == null) {
            this.costTypeCombo = new BGComboBox();
            this.costTypeCombo.addItem((Object)new ComboBoxItem((Object)"min", "\u043c\u0438\u043d\u0443\u0442\u044b"));
            this.costTypeCombo.addItem((Object)new ComboBoxItem((Object)"call", "\u0437\u0432\u043e\u043d\u043a\u0430"));
            this.costSourceCombo = new BGComboBox();
            this.costSourceCombo.addItem((Object)new ComboBoxItem((Object)"node", "="));
            this.costSourceCombo.addItem((Object)new ComboBoxItem((Object)"costMap", "\u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"));
            this.costSourceCombo.addItem((Object)new ComboBoxItem((Object)"cdr", "\u0432\u0437\u044f\u0442\u044c \u0438\u0437 CDR"));
            this.cost = new FloatTextField();
            this.cost.setColumns(10);
            this.defaultPrice = new JCheckBox("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            propsPanel.add(new JLabel(this.getLabelTitle()));
            propsPanel.add((Component)this.costTypeCombo);
            propsPanel.add((Component)this.costSourceCombo);
            propsPanel.add((Component)this.cost);
            propsPanel.add(this.defaultPrice);
        }
        return propsPanel;
    }

    public Component getView() {
        this.extractData();
        StringBuilder labelText = new StringBuilder(100);
        labelText.append(this.getLabelTitle());
        if (this.costType.equals("call")) {
            labelText.append(" \u0437\u0432\u043e\u043d\u043a\u0430");
        } else {
            labelText.append(" \u043c\u0438\u043d\u0443\u0442\u044b");
        }
        if (this.costSource.equals("costMap")) {
            labelText.append(" \u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d");
        } else if (this.costSource.equals("cdr")) {
            labelText.append(" \u0432\u0437\u044f\u0442\u044c \u0432 CDR");
        } else {
            labelText.append(" = ");
            labelText.append(this.costValue);
        }
        if (this.isDefault) {
            labelText.append(" *");
        }
        this.view.setText(labelText.toString());
        return this.view;
    }

    protected String getLabelTitle() {
        return "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c";
    }
}

