/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.FiasConfigUtil;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationUploader;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.UploadFileRow;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class PhoneLocationUploader
extends LocationUploader {
    public PhoneLocationUploader(int moduleId) {
        super(moduleId);
    }

    public List<UploadFileRow> getRowList() throws BGException {
        ArrayList<UploadFileRow> result = new ArrayList<UploadFileRow>();
        result.addAll(this.getNoObjectNumber());
        result.addAll(this.getObjectNumber());
        return result;
    }

    public List<UploadFileRow> getObjectNumber() throws BGException {
        ArrayList<UploadFileRow> result = new ArrayList<UploadFileRow>();
        try {
            String tablePhoneItemNumber = ServerUtils.getModuleTableName((String)"phone_item_number", (int)this.moduleId);
            String tablePhoneClientItem_ = ServerUtils.getModuleTableName((String)"phone_client_item", (int)this.moduleId);
            PreparedStatement ps = this.con.prepareStatement("SELECT  t_num.number AS number, f_h.houseguid AS houseGuid, f_h.housenum AS houseNum, f_h.buildnum AS buildnum, f_h.strucnum AS strucnum, f_h.eststatus AS eststatus, f_h.strstatus AS strstatus, t_type.pod AS pod, t_type.floor AS floor, t_type.flat AS room, t_name.val AS name, t_last_name.val AS lastName, t_patr.val AS secondName, t_type.address AS addressString, t_dob_txt.val AS dob_txt, t_dob_data.val AS dob_data, t_h.streetid AS streetId, s.cityid AS cityId, c.fc AS fc FROM " + tablePhoneItemNumber + " as t_num JOIN " + tablePhoneClientItem_ + " AS t_item ON t_item.id=t_num.item_id JOIN contract AS c ON c.id = t_item.cid LEFT JOIN object_param_value_address AS t_type ON t_type.object_id = t_item.object_id AND t_type.param_id = ? LEFT JOIN contract_parameter_type_1 AS t_name ON t_name.cid = t_item.cid AND ((c.fc=0 AND t_name.pid =?)  OR (c.fc=1 AND t_name.pid =?))  LEFT JOIN contract_parameter_type_1 AS t_last_name ON t_last_name.cid = t_item.cid AND ((c.fc=0 AND t_last_name.pid =?) OR (c.fc=1 AND t_last_name.pid =?)) LEFT JOIN contract_parameter_type_1 AS t_patr ON t_patr.cid = t_item.cid AND ((c.fc=0 AND t_patr.pid =?)  OR (c.fc=1 AND t_patr.pid =?))  LEFT JOIN contract_parameter_type_1 AS t_dob_txt ON t_dob_txt.cid = t_item.cid AND t_dob_txt.pid =?  LEFT JOIN contract_parameter_type_1 AS t_dob_data ON t_dob_data.cid = t_item.cid AND t_dob_data.pid = ? LEFT JOIN address_house AS t_h ON t_h.id = t_type.hid LEFT JOIN address_street AS s ON s.id = t_h.streetid LEFT JOIN fias_house_map AS f_h ON f_h.id = t_h.id WHERE t_item.object_id <> 0 AND (t_item.date1 IS NULL OR t_item.date1 <?) AND (t_item.date2 IS NULL OR t_item.date2 >?)");
            int index = 1;
            ps.setInt(index++, FiasConfigUtil.getObjectAddressPid());
            ps.setInt(index++, FiasConfigUtil.getNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getLastNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getLastNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getSecondNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getSecondNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getDobAsTextPid());
            ps.setInt(index++, FiasConfigUtil.getDobAsDatePid());
            GregorianCalendar now = new GregorianCalendar();
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UploadFileRow row = this.loadRowFromRs(rs);
                if (row == null) continue;
                result.add(row);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<UploadFileRow> getNoObjectNumber() throws BGException {
        ArrayList<UploadFileRow> result = new ArrayList<UploadFileRow>();
        try {
            String tablePhoneItemNumber = ServerUtils.getModuleTableName((String)"phone_item_number", (int)this.moduleId);
            String tablePhoneClientItem_ = ServerUtils.getModuleTableName((String)"phone_client_item", (int)this.moduleId);
            PreparedStatement ps = this.con.prepareStatement("SELECT  t_num.number AS number, f_h.houseguid AS houseGuid, f_h.housenum AS houseNum, f_h.buildnum AS buildnum, f_h.strucnum AS strucnum, f_h.eststatus AS eststatus, f_h.strstatus AS strstatus, t_type.pod AS pod, t_type.floor AS floor, t_type.flat AS room, t_name.val AS name, t_last_name.val AS lastName, t_patr.val AS secondName, t_type.address AS addressString, t_dob_txt.val AS dob_txt, t_dob_data.val AS dob_data, t_h.streetid AS streetId, s.cityid AS cityId, c.fc AS fc FROM " + tablePhoneItemNumber + " as t_num JOIN " + tablePhoneClientItem_ + " AS t_item ON t_item.id=t_num.item_id JOIN contract AS c ON c.id = t_item.cid LEFT JOIN contract_parameter_type_2 AS t_type ON t_type.cid = t_item.cid AND ((c.fc=0 AND t_type.pid =?) OR (c.fc=1 AND t_type.pid =?)) LEFT JOIN contract_parameter_type_1 AS t_name ON t_name.cid = t_item.cid AND ((c.fc=0 AND t_name.pid =?)  OR (c.fc=1 AND t_name.pid =?))  LEFT JOIN contract_parameter_type_1 AS t_last_name ON t_last_name.cid = t_item.cid AND ((c.fc=0 AND t_last_name.pid =?) OR (c.fc=1 AND t_last_name.pid =?)) LEFT JOIN contract_parameter_type_1 AS t_patr ON t_patr.cid = t_item.cid AND ((c.fc=0 AND t_patr.pid =?)  OR (c.fc=1 AND t_patr.pid =?))  LEFT JOIN contract_parameter_type_1 AS t_dob_txt ON t_dob_txt.cid = t_item.cid AND t_dob_txt.pid =?  LEFT JOIN contract_parameter_type_1 AS t_dob_data ON t_dob_data.cid = t_item.cid AND t_dob_data.pid = ? LEFT JOIN address_house AS t_h ON t_h.id = t_type.hid LEFT JOIN address_street AS s ON s.id = t_h.streetid LEFT JOIN fias_house_map AS f_h ON f_h.id = t_h.id WHERE t_item.object_id = 0 AND (t_item.date1 IS NULL OR t_item.date1 <?) AND (t_item.date2 IS NULL OR t_item.date2 >?)");
            int index = 1;
            ps.setInt(index++, FiasConfigUtil.getAddressPid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getAddressPid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getLastNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getLastNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getSecondNamePid((boolean)true));
            ps.setInt(index++, FiasConfigUtil.getSecondNamePid((boolean)false));
            ps.setInt(index++, FiasConfigUtil.getDobAsTextPid());
            ps.setInt(index++, FiasConfigUtil.getDobAsDatePid());
            GregorianCalendar now = new GregorianCalendar();
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            LogManager.getLogger().debug(ps.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UploadFileRow row = this.loadRowFromRs(rs);
                if (row == null) continue;
                result.add(row);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private UploadFileRow loadRowFromRs(ResultSet rs) throws SQLException, BGException {
        UploadFileRow row = new UploadFileRow();
        row.setNumber(rs.getString("number"));
        row.setHouseGuid(rs.getString("houseGuid"));
        row.setHousenum(Utils.maskNull((String)rs.getString("houseNum")));
        row.setBuildnum(Utils.maskNull((String)rs.getString("buildnum")));
        row.setStrucnum(Utils.maskNull((String)rs.getString("strucnum")));
        row.setEststatus(Utils.maskNull((String)rs.getString("eststatus")));
        row.setStrstatus(Utils.maskNull((String)rs.getString("strstatus")));
        row.setPod(Utils.maskNull((String)rs.getString("pod")));
        row.setFloor(Utils.maskNull((String)rs.getString("floor")));
        row.setRoom(Utils.maskNull((String)rs.getString("room")));
        row.setUnstructuredAddress("");
        row.setAbonUse("1");
        row.setAbonType(rs.getInt("fc") == 0 ? "2" : "1");
        row.setName(Utils.maskNull((String)rs.getString("name")));
        row.setLastName(Utils.maskNull((String)rs.getString("lastName")));
        row.setSecondName(Utils.maskNull((String)rs.getString("secondName")));
        row.setAddressString(Utils.maskNull((String)rs.getString("addressString")));
        String dob = rs.getString("dob_data");
        if (Utils.isEmptyString((String)dob) && Utils.isEmptyString((String)(dob = rs.getString("dob_txt")))) {
            dob = "";
        }
        row.setDob(dob);
        row.setComment("");
        row.setFullStreet("");
        row.setCityId(rs.getInt("cityId"));
        row.setStreetId(rs.getInt("streetId"));
        if (!row.verified()) {
            return null;
        }
        row.setFc(rs.getInt("fc"));
        row.SplitNameToPart();
        return row;
    }
}

