/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMTariffRequestResult;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmServiceCost;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffContext;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffRequest;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class RSCMCalculatorUtils {
    public static void doCalc(RscmTariffContext rscmTariffContext, List<Integer> contractIds, PeriodicErrorManager errorManager, Logger log) throws Exception {
        Period period = rscmTariffContext.getPeriod();
        Connection con = rscmTariffContext.getConnectionSet().getConnection();
        String tableName = "rscm_service_account_" + rscmTariffContext.getModuleId();
        String installmentTableName = "rscm_service_account_installment_" + rscmTariffContext.getModuleId();
        log.info("Processing {} [{}]", (Object)tableName, (Object)TimeUtils.formatPeriod((Period)period));
        log.debug("contractIds={}", (Object)Utils.toString(contractIds));
        String query = "SELECT s.cid, s.sid, s.date, s.amount_up, s.amount_down, s.amount_last, c.domainId, i.date_from, i.amount_up FROM " + tableName + " AS s INNER JOIN `contract` AS c ON c.id=s.cid LEFT JOIN " + installmentTableName + " AS i ON i.id=s.installment_id WHERE s.date >= ? AND s.date < ?" + (Utils.isEmptyCollection(contractIds) ? "" : " AND s.cid=?");
        if (Utils.isEmptyCollection(contractIds)) {
            contractIds = Arrays.asList(0);
        }
        HashSet<Integer> balanceContractIds = new HashSet<Integer>();
        ServiceCostCache costCache = new ServiceCostCache();
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            for (Integer contractId : contractIds) {
                if (contractId > 0) {
                    ps.setInt(3, contractId);
                    balanceContractIds.add(contractId);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        int serviceContractId = rs.getInt("s.cid");
                        int serviceId = rs.getInt("s.sid");
                        int domainId = rs.getInt("c.domainId");
                        int amount = rs.getInt("i.amount_up");
                        int amountUp = rs.getInt("s.amount_up");
                        int amountDown = rs.getInt("s.amount_down");
                        amountDown = amountDown == 0 ? 100 : amountDown;
                        boolean last = rs.getInt("s.amount_last") > 0;
                        LocalDate serviceDate = TimeUtils.convertDateToLocalDate((Date)rs.getDate("s.date"));
                        LocalDate installmentServiceDate = TimeUtils.convertDateToLocalDate((Date)rs.getDate("i.date_from"));
                        LocalDate date = installmentServiceDate != null ? installmentServiceDate : serviceDate;
                        RSCMTariffRequestResult result = RSCMCalculatorUtils.processTariffRequest(costCache, domainId, serviceContractId, serviceId, amount, amountUp, amountDown, last, date, rscmTariffContext, log);
                        if (!result.accepted && errorManager != null && !errorManager.isCapReached()) {
                            String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + serviceContractId + "): \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d.\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId + ". \u0414\u0430\u0442\u0430: " + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + ".";
                            errorManager.addErrorToList("\u041e\u0448\u0438\u0431\u043a\u0430!", text);
                            log.error("Tariff request wasn't processed: " + result.tariffRequestString);
                        }
                        balanceContractIds.add(serviceContractId);
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("balanceContractIds={};", (Object)Utils.toString(balanceContractIds));
            for (CostSum costSum : costCache.getAmounts()) {
                log.debug("costSum={};", (Object)costSum);
            }
        }
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            String sids = ModuleCache.getInstance().getModuleServicesString(rscmTariffContext.getModuleId());
            log.debug("moduleId={}; sids={};", (Object)rscmTariffContext.getModuleId(), (Object)sids);
            balanceUtils.setAccount(con, log, TimeUtils.convertDateToCalendar((Date)period.getDateFrom()), costCache, sids, Utils.toString(balanceContractIds), null);
        }
    }

    public static RSCMTariffRequestResult processTariffRequest(ServiceCostCache costCache, int domainId, int contractId, int serviceId, int amount, int amountUp, int amountDown, boolean last, LocalDate serviceDate, RscmTariffContext rscmTariffContext, Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("domainId={}; contractId={}; serviceId={}; amountUp={}; amountDown={}; last={}, serviceDate={}", new Object[]{domainId, contractId, serviceId, amountUp, amountDown, last, serviceDate});
        }
        RSCMTariffRequestResult result = new RSCMTariffRequestResult();
        Connection con = rscmTariffContext.getConnectionSet().getConnection();
        try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(con);){
            int tariffCounter = 0;
            Date date = TimeUtils.convertLocalDateToDate((LocalDate)serviceDate).after(rscmTariffContext.getFromTime()) ? TimeUtils.convertLocalDateToDate((LocalDate)serviceDate) : rscmTariffContext.getFromTime();
            TariffModuleTreeSet tariffModuleTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, date, "rscm", rscmTariffContext.getModuleId(), 0, 0);
            logger.debug("tariffModuleTreeSet.size()={}", (Object)tariffModuleTreeSet.entries().length);
            for (TariffModuleTreeSet.Entry tariffTree : tariffModuleTreeSet.entries()) {
                RscmTariffRequest rscmTariffRequest = new RscmTariffRequest(domainId, rscmTariffContext.getModuleId(), contractId);
                rscmTariffRequest.setConnectionSet(rscmTariffContext.getConnectionSet());
                rscmTariffRequest.setTime(TimeUtils.convertLocalDateToCalendar((LocalDate)serviceDate));
                rscmTariffRequest.addServiceCost(new RscmServiceCost(serviceId, serviceDate, serviceDate, serviceDate, serviceDate));
                rscmTariffRequest.setTariffTreeSetEntry(tariffTree);
                tariffTree.getTree().execute((AbstractTariffRequest)rscmTariffRequest, (TariffContext)rscmTariffContext);
                if (!rscmTariffRequest.isAccepted()) continue;
                result.accepted = true;
                result.cost = ((RscmServiceCost)rscmTariffRequest.serviceCost).getCost();
                result.divisor = ((RscmServiceCost)rscmTariffRequest.serviceCost).divisor;
                logger.debug("result.cost = {}; result.divisor = {}", (Object)result.cost, (Object)result.divisor);
                BigDecimal cost = BigDecimal.ZERO;
                BigDecimal unitCost = result.cost.divide(result.divisor, 2, RoundingMode.HALF_UP);
                if (last) {
                    cost = unitCost.divide(new BigDecimal(amountDown), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(amount));
                    cost = cost.add(unitCost.divide(new BigDecimal(amountDown), 2, RoundingMode.DOWN).multiply(new BigDecimal(amount - amountUp).negate()));
                } else {
                    cost = unitCost.divide(new BigDecimal(amountDown), 2, RoundingMode.DOWN).multiply(new BigDecimal(amountUp));
                }
                costCache.addAmount(new CostSum(contractId, serviceId, cost));
                ++tariffCounter;
                break;
            }
            if (!result.accepted) {
                result.tariffRequestString = "\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430. \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0442\u0430\u0440\u0438\u0444\u043e\u0432: " + tariffCounter;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static LocalDate getInstallmentPaymentNextDate(LocalDate date, String paymentMode) {
        Objects.requireNonNull(date);
        Objects.requireNonNull(paymentMode);
        return switch (paymentMode) {
            case "day" -> date.plusDays(1L);
            case "week" -> date.plusWeeks(1L);
            case "quarter" -> date.plusMonths(3L);
            case "month" -> date.plusMonths(1L);
            case "monthFirst" -> date.withDayOfMonth(1).plusMonths(1L);
            case "monthLast" -> date.withDayOfMonth(1).plusMonths(1L).minusDays(1L);
            case "year" -> date.plusYears(1L);
            default -> throw new IllegalArgumentException("Unexpected value: " + paymentMode);
        };
    }
}

