/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class SaveInFileDialog
extends JDialog {
    private SQLEditor sqlEditor;
    private BGSelectFilePanel selectFile = new BGSelectFilePanel(true);
    private BGButtonPanelOkCancel panelOkCancel = new BGButtonPanelOkCancel();

    public SaveInFileDialog(SQLEditor sqlEditor) {
        super(JOptionPane.getRootFrame());
        this.setTitle("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0444\u0430\u0439\u043b");
        this.setModal(true);
        this.setResizable(false);
        this.sqlEditor = sqlEditor;
        this.selectFile.setFileFieldBackground(UIManager.getColor("TextField.background"));
        this.selectFile.setFileFilter("csv", "CSV");
        this.panelOkCancel.addActionListener(actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if ("ok".equals(actionCommand)) {
                try {
                    this.save();
                }
                catch (IOException | BGException e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
            } else if ("cancel".equals(actionCommand)) {
                this.close();
            }
        });
        Dimension dimension = new Dimension(400, 10);
        JLabel label = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b:");
        label.setMinimumSize(dimension);
        label.setPreferredSize(dimension);
        int gridy = 0;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)label, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 0, 10), 0, 0));
        container.add((Component)this.selectFile, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 10, 0, 10), 0, 0));
        container.add((Component)this.panelOkCancel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getRootFrame());
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void save() throws IOException, BGException {
        SQLEditor.ResultSetPanel resultSetPanel = (SQLEditor.ResultSetPanel)this.sqlEditor.getResultSetTabbedPane().getSelectedComponent();
        if (resultSetPanel.getCurrentSql() != null) {
            String sql = resultSetPanel.getCurrentSql().toLowerCase().trim();
            if (sql.startsWith("select") || sql.startsWith("show")) {
                File outFile = this.selectFile.getSelectedFile();
                if (outFile == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                    return;
                }
                JSONObject result = new JSONObject(this.sqlEditor.getSqlEditorService().doQuery(ClientUtils.getIdFromComboBox(this.sqlEditor.getDatabaseList()), resultSetPanel.getCurrentSql(), null, null));
                JSONArray columnsArray = result.optJSONArray("columns");
                JSONArray rows = result.optJSONArray("rows");
                ArrayList<CallSite> rowLines = new ArrayList<CallSite>();
                for (int x = 0; x < rows.length(); ++x) {
                    StringBuilder line = new StringBuilder();
                    JSONObject jSONObject = (JSONObject)rows.get(x);
                    for (int i = 0; i < columnsArray.length(); ++i) {
                        line.append(jSONObject.optString("c" + i));
                        if (i + 1 >= columnsArray.length()) continue;
                        line.append(";");
                    }
                    rowLines.add((CallSite)((Object)(line.toString() + "\n")));
                }
                try (FileWriter fileWriter = new FileWriter(outFile);){
                    fileWriter.write(columnsArray.join(";").replaceAll("\"", ""));
                    if (Utils.notEmptyCollection(rowLines)) {
                        fileWriter.write("\r\n\r\n");
                    }
                    for (String string : rowLines) {
                        fileWriter.write(string);
                    }
                }
            } else {
                JTextArea message = new JTextArea(10, 50);
                message.setWrapStyleWord(true);
                message.setLineWrap(true);
                message.setMargin(new Insets(3, 3, 3, 3));
                message.setEditable(false);
                message.setText("\u041c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e SELECT \u0438 SHOW \u0437\u0430\u043f\u0440\u043e\u0441\u044b!\n\n" + sql);
                Dimension dimension = new Dimension(500, 200);
                JScrollPane scrollPane = new JScrollPane(message);
                scrollPane.setMinimumSize(dimension);
                scrollPane.setPreferredSize(dimension);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
            }
        } else {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0447\u0435\u0433\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c!");
        }
        this.close();
    }
}

