/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.modules.voice.client.contract.report.BGDetailTable;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetail;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetailReportItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SessionDetailPanel
extends BGUPanel {
    private BGDetailTable table = new BGDetailTable();

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane((Component)((Object)this.table)));
    }

    public void setData(List<SessionDetail<SessionDetail<SessionDetailReportItem>>> data) {
        this.table.removeRows();
        for (SessionDetail<SessionDetail<SessionDetailReportItem>> service : data) {
            Vector<String> row = new Vector<String>();
            row.addElement("\u0423\u0441\u043b\u0443\u0433\u0430: " + (service.getServiceId() > 0 ? service.getService() : "\u0431\u0435\u0437 \u0443\u0441\u043b\u0443\u0433\u0438"));
            this.table.addRow(row, true);
            for (SessionDetail account : service.getResult()) {
                row = new Vector();
                row.addElement("\u041d\u043e\u043c\u0435\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430: " + account.getNumberA());
                this.table.addRow(row, true);
                for (SessionDetailReportItem item : account.getResult()) {
                    row = new Vector();
                    row.addElement(TimeUtils.format((Date)item.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss"));
                    row.addElement(item.getDestination());
                    row.addElement(item.getNumberA());
                    row.addElement(item.getNumberB());
                    row.addElement(Utils.formatSessionTime((int)item.getDuration()));
                    row.addElement(Utils.formatSessionTime((int)item.getDurationRound()));
                    row.addElement(item.getCost().toPlainString());
                    this.table.addRow(row, false);
                }
                row = new Vector();
                BigDecimal accountSumm = Utils.maskNull((BigDecimal)account.getSumm());
                row.addElement(String.format("\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443: \u043a\u043e\u043b-\u0432\u043e %,d, \u0441\u0443\u043c\u043c\u0430 %s, \u0434\u043b\u0438\u0442.(\u043c\u0438\u043d) %,d, \u0434\u043b\u0438\u0442. \u043e\u043a\u0440.(\u043c\u0438\u043d) %,d", account.getCount(), Utils.formatCostByGrouping((BigDecimal)accountSumm, (int)3, (int)accountSumm.scale()), account.getAmount() / 60L, account.getAmountRound() / 60L));
                this.table.addRow(row, true);
            }
            row = new Vector();
            BigDecimal serviceSumm = Utils.maskNull((BigDecimal)service.getSumm());
            row.addElement(String.format("\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435: \u043a\u043e\u043b-\u0432\u043e %,d, \u0441\u0443\u043c\u043c\u0430 %s, \u0434\u043b\u0438\u0442.(\u043c\u0438\u043d) %,d, \u0434\u043b\u0438\u0442. \u043e\u043a\u0440.(\u043c\u0438\u043d) %,d", service.getCount(), Utils.formatCostByGrouping((BigDecimal)serviceSumm, (int)3, (int)serviceSumm.scale()), service.getAmount() / 60L, service.getAmountRound() / 60L));
            this.table.addRow(row, true);
        }
    }
}

