/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitArrayOutputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitInputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CDCAS30Exception;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CloseAccountRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CreateSessionRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CreateSessionResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.EntitlementRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.OpenAccountRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Request;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Response;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.SendMailRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.SendOSDRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class CDCAS30Connection
extends BGLogger {
    private String host;
    private int port;
    private int timeout;
    private Socket socket;
    private OutputStream os;
    private InputStream is;
    private int OPE_ID;
    private int SMS_ID;
    private String rootkey;
    private int tape_ctrl = 1;
    private int osdStyle;
    private int osdDuration;
    private String emailCharset;
    private String osdCharset;

    public CDCAS30Connection(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 0);
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined");
        }
        this.timeout = preferences.getInt("timeout", 30000);
        this.OPE_ID = preferences.getInt("OPE_ID", 0);
        this.SMS_ID = preferences.getInt("SMS_ID", 0);
        this.rootkey = preferences.get("rootkey", null);
        if (Utils.isEmptyString((String)this.rootkey)) {
            throw new BGException("rootkey for server " + serverId + " undefined");
        }
        this.osdStyle = preferences.getInt("osdStyle", 2);
        this.osdDuration = preferences.getInt("osdDuration", 60);
        this.emailCharset = preferences.get("emailCharset", "utf-8");
        this.osdCharset = preferences.get("osdCharset", "utf-8");
    }

    public <Q extends Request<Q, P>, P extends Response<Q, P>> P sendRequest(Q packet) throws BGException, IOException {
        this.$trace("send command " + packet.getClass().getSimpleName(), new Object[0]);
        BitArrayOutputStream os_packet = new BitArrayOutputStream(666);
        packet.writePacket(os_packet);
        os_packet.close();
        this.os.write(os_packet.toByteArray());
        this.os.flush();
        P result = packet.getResponse();
        ((Packet)result).readPacket(new BitInputStream(this.is));
        this.$trace("get response " + result.getClass().getSimpleName() + ": " + ((Packet)result).toString(), new Object[0]);
        if (((Response)result).getErrorCode() != 0) {
            throw new CDCAS30Exception(((Response)result).getErrorCode());
        }
        return result;
    }

    public void connect() throws IOException, BGException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setSoTimeout(this.timeout);
        this.os = new BufferedOutputStream(this.socket.getOutputStream());
        this.is = new BufferedInputStream(this.socket.getInputStream());
    }

    public void disconnect() throws IOException {
        this.is.close();
        this.is = null;
        this.os.close();
        this.os = null;
        this.socket.close();
        this.socket = null;
    }

    public int getOPE_ID() {
        return this.OPE_ID;
    }

    public int getSMS_ID() {
        return this.SMS_ID;
    }

    public String getRootkey() {
        return this.rootkey;
    }

    public void createSession() throws BGException, IOException {
        CreateSessionRequest request = new CreateSessionRequest(this, 1);
        CreateSessionResponse response = (CreateSessionResponse)this.sendRequest(request);
        this.$trace("session key: " + Utils.bytesToString((byte[])response.getSessionKey()), new Object[0]);
    }

    public void openAccount(long card_sn) throws BGException, IOException {
        OpenAccountRequest request = new OpenAccountRequest(this, 1);
        request.setCardSn(card_sn);
        this.sendRequest(request);
    }

    public void closeAccount(long card_sn) throws BGException, IOException {
        CloseAccountRequest request = new CloseAccountRequest(this, 1);
        request.setCardSn(card_sn);
        this.sendRequest(request);
    }

    public void entitlement(long card_sn, final int packageId, final Date startTime, final Date endTime, boolean enti_type) throws BGException, IOException {
        EntitlementRequest request = new EntitlementRequest(this, 1);
        request.setCardSn(card_sn);
        request.setEntiType(enti_type ? 1 : 0);
        request.setProductEntrys((List<EntitlementRequest.ProductEntry>)new ArrayList<EntitlementRequest.ProductEntry>(){
            {
                this.add(new EntitlementRequest.ProductEntry(packageId, CDCAS30Connection.this.tape_ctrl, startTime, endTime));
            }
        });
        this.sendRequest(request);
    }

    public void sendMail(long cardNumber, String title, String message) throws BGException, IOException {
        SendMailRequest request = new SendMailRequest(this, 1);
        request.setCardSn(cardNumber);
        request.setData(title, message, this.emailCharset);
        this.sendRequest(request);
    }

    public void sendOSD(long cardNumber, String message) throws BGException, IOException {
        SendOSDRequest request = new SendOSDRequest(this, 1);
        request.setCardSn(cardNumber);
        request.setData(message, this.osdStyle, this.osdDuration, this.osdCharset);
        this.sendRequest(request);
    }

    private void $trace(String format, Object ... args) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format(format, args));
        }
    }
}

