/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.gazprombank.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.gazprombank.common.service.GazprombankService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JPanel getExtraFilterPanel() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u0441\u0435\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(e -> {
            try {
                ((GazprombankService)((ClientContext)this.getContext()).getPort(GazprombankService.class)).checkTransactions(this.getContractId());
                this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)button, new GridBagConstraints(panel.getComponentCount(), 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchParam searchParam = new SearchParam().setContractId(this.getContractId()).setContractTitle(this.contractTitleField.getText()).setStatus(((AbstractTransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setType((PaymentType)Optional.ofNullable(this.paymentTypes).map(a -> (KeyValue)a.getSelectedItem()).map(a -> PaymentType.getPaymentTypeByName((String)a.getKey())).orElse(null)).setPeriod(this.periodPanel.getPeriod()).setSort(this.getTable().getSort()).setPage(this.pagePanel.getPage());
            SearchResult searchResult = ((GazprombankService)((ClientContext)this.getContext()).getPort(GazprombankService.class)).searchTransactionList(searchParam);
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
    }
}

