/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.apps;

import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.apps.ActionAbstract;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.common.Utils;

public class ActionSendMessage
extends ActionAbstract {
    private TopicManager topicManager = null;

    public void execute() throws Exception {
        this.topicManager = new TopicManager(this.con, this.plugin);
        Message message = null;
        int iownerId = this.getIntParameter("messageId", -1);
        int topicId = this.getIntParameter("topicId", -1);
        if (iownerId <= 0) {
            message = this.createMessage(topicId);
            iownerId = message.getId();
        }
        if (message != null) {
            message.setFileList(this.fileUploadRequest(message));
            List<Message> list = this.topicManager.getMessageListRevert(topicId, message.getId(), 5, true);
            this.actionMap.put("messages", list);
            this.actionMap.put("message", message);
        }
    }

    private Message createMessage(int topicId) throws Exception {
        Topic topic;
        String textMessage = this.getParameter("text");
        if (Utils.isBlankString((String)textMessage)) {
            if (this.request instanceof MultipartWrapper) {
                textMessage = "attach message";
            } else {
                throw new BGMessageException("\u041f\u0443\u0441\u0442\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
            }
        }
        if ((topic = this.topicManager.getTopic(topicId)) == null) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (topic.isClosed()) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        }
        Message message = Message.builder().setTopicId(topicId).setUserIdFrom(0).setDateFrom(new Date()).setBody(textMessage).build();
        this.helpdeskService.messageUpdate(message);
        return message;
    }
}

