/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.server.util.UserMap;

public class ManagerChangeManager {
    protected Connection con;
    protected BGPluginServer plugin = null;

    public ManagerChangeManager(Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public List<ChangeManager> getListOfChange(int topicId) throws BGException {
        ArrayList<ChangeManager> historyList = new ArrayList<ChangeManager>();
        String query = "SELECT * FROM " + this.getDBTableName("helpdesk_topic_manager_change") + " WHERE topic_id=? ORDER BY date DESC";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, topicId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ChangeManager changeManager = new ChangeManager();
                    changeManager.setComment(rs.getString("comment"));
                    changeManager.setTopicId(rs.getInt("topic_id"));
                    changeManager.setUserId(rs.getInt("user_id"));
                    changeManager.setUserName(changeManager.getUserId() > 0 ? UserMap.getUser((Integer)changeManager.getUserId()).getName() : "-");
                    changeManager.setDate((Date)rs.getTimestamp("date"));
                    historyList.add(changeManager);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return historyList;
    }
}

