/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.ipn.common.bean.BGDecimalFormat;

public class TablePanel
extends JPanel {
    final DecimalFormat format = new BGDecimalFormat("###,###,###,###.##");
    int unit = 0x100000;
    int items = -1;
    long[] tableValue = null;
    private String[] labels = null;
    private JTextPane tablePane = new JTextPane();

    public TablePanel() {
        try {
            this.jbInit();
            this.tablePane.setEditable(false);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.tablePane), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData(int items, long[] tableValue, String[] labels) {
        if (items == -1 || tableValue == null || labels == null) {
            return;
        }
        this.items = items;
        this.tableValue = tableValue;
        this.labels = labels;
        this.buildTable();
    }

    private void buildTable() {
        int row = 2;
        int col = 3;
        while (this.items > row * col) {
            ++row;
        }
        this.tablePane.setContentType("text/html");
        StringBuffer txt = new StringBuffer();
        txt.append("<html><head>");
        txt.append("<style type='text/css'>");
        txt.append("body { font-family: arial; }");
        txt.append(".tdt { font-size: 12pt; text-align: center; background-color: #f0f0e0; }");
        txt.append(".tdv { font-size: 12pt; text-align: center; background-color: #ffffff; }");
        txt.append("</style>");
        txt.append("</head><body><center>");
        txt.append("<table border='1' cellpadding='1' width='90%'>");
        for (int r = 0; r < row; ++r) {
            txt.append("<tr>");
            for (int c = 0; c < col; ++c) {
                int i = r + c * row;
                String s1 = "";
                String s2 = "";
                if (i < this.labels.length) {
                    s1 = this.labels[i];
                    s2 = this.format.format((double)this.tableValue[i] / (double)this.unit);
                }
                txt.append("<td class='tdt' width='30'>" + s1 + "</td>");
                txt.append("<td class='tdv'>" + s2 + "</td>");
            }
            txt.append("</tr>");
        }
        txt.append("</table></center></body></html>");
        this.tablePane.setText(txt.toString());
    }

    public void setUnit(int unit) {
        this.unit = unit;
        this.buildTable();
    }
}

