/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.common.util.Ranger;

public class RangeSet<C, R> {
    private final Comparator<Entry> entryComaprator;
    private final Ranger<R, C> ranger;
    private final Comparator<C> comparator;
    private final Class<R> rangeClazz;
    private final Class<C> clazz;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile Entity entity;
    private final ConcurrentMap<R, R> rangeSet;
    private final boolean canRangeInRange = true;

    protected RangeSet(Ranger<R, C> ranger, final Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz, Set<R> rangeSet) {
        this.ranger = ranger;
        this.comparator = comparator;
        this.rangeClazz = rangeClazz;
        this.clazz = clazz;
        this.entryComaprator = new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return comparator.compare(o1.c, o2.c);
            }
        };
        this.rangeSet = new ConcurrentHashMap<R, R>(Math.min(rangeSet.size(), 64));
        for (R range : rangeSet) {
            this.rangeSet.put(range, range);
        }
        this.entity = this.create(this.rangeSet, true);
    }

    public RangeSet(Ranger<R, C> ranger, Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz) {
        this(ranger, comparator, rangeClazz, clazz, Collections.emptySet());
    }

    private Entity create(Map<R, R> rangeSet, boolean canIntersect) {
        Entry e;
        int size = rangeSet.size();
        ArrayList<Entry> minEntry = new ArrayList<Entry>(size);
        ArrayList<Entry> maxEntry = new ArrayList<Entry>(size);
        Object[] ranges = (Object[])Array.newInstance(this.rangeClazz, size);
        int i = 0;
        for (R r : rangeSet.keySet()) {
            ranges[i] = r;
            minEntry.add(new Entry(i, this.ranger.getMinValue(r)));
            maxEntry.add(new Entry(i, this.ranger.getMaxValue(r)));
            ++i;
        }
        Collections.sort(minEntry, this.entryComaprator);
        Collections.sort(maxEntry, this.entryComaprator);
        ArrayList min = new ArrayList(size);
        int[] minIndex = new int[size];
        ArrayList max = new ArrayList(size);
        int[] maxIndex = new int[size];
        for (i = 0; i < size; ++i) {
            e = (Entry)minEntry.get(i);
            min.add(e.c);
            minIndex[i] = e.index;
        }
        for (i = 0; i < size; ++i) {
            e = (Entry)maxEntry.get(i);
            max.add(e.c);
            maxIndex[i] = e.index;
        }
        if (!canIntersect && !Arrays.equals(minIndex, maxIndex)) {
            throw new IllegalArgumentException();
        }
        Object[] maxArray = max.toArray((Object[])Array.newInstance(this.clazz, size));
        Object[] minArray = min.toArray((Object[])Array.newInstance(this.clazz, size));
        return new Entity(this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, minArray, minIndex, maxArray, maxIndex, canIntersect);
    }

    private Entity add(Entity entity, R range) {
        int minPos = Arrays.binarySearch(entity.min, this.ranger.getMinValue(range), this.comparator);
        int maxPos = Arrays.binarySearch(entity.max, this.ranger.getMaxValue(range), this.comparator);
        if (minPos < 0) {
            minPos = -minPos - 1;
        }
        if (maxPos < 0) {
            maxPos = -maxPos - 1;
        }
        if (!entity.canRangeInRange && minPos != maxPos) {
            throw new IllegalArgumentException();
        }
        Object[] min = (Object[])Array.newInstance(this.clazz, entity.min.length + 1);
        System.arraycopy(entity.min, 0, min, 0, minPos);
        min[minPos] = this.ranger.getMinValue(range);
        System.arraycopy(entity.min, minPos, min, minPos + 1, entity.min.length - minPos);
        int[] minIndex = new int[entity.minIndex.length + 1];
        System.arraycopy(entity.minIndex, 0, minIndex, 0, minPos);
        minIndex[minPos] = entity.ranges.length;
        System.arraycopy(entity.minIndex, minPos, minIndex, minPos + 1, entity.minIndex.length - minPos);
        Object[] max = (Object[])Array.newInstance(this.clazz, entity.max.length + 1);
        System.arraycopy(entity.max, 0, max, 0, maxPos);
        max[maxPos] = this.ranger.getMaxValue(range);
        System.arraycopy(entity.max, maxPos, max, maxPos + 1, entity.max.length - maxPos);
        int[] maxIndex = new int[entity.maxIndex.length + 1];
        System.arraycopy(entity.maxIndex, 0, maxIndex, 0, maxPos);
        maxIndex[maxPos] = entity.ranges.length;
        System.arraycopy(entity.maxIndex, maxPos, maxIndex, maxPos + 1, entity.maxIndex.length - maxPos);
        R[] ranges = Arrays.copyOf(entity.ranges, entity.ranges.length + 1);
        ranges[entity.ranges.length] = range;
        return new Entity(this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, min, minIndex, max, maxIndex, entity.canRangeInRange);
    }

    private Entity remove(Entity entity, R range) {
        int minPos = Arrays.binarySearch(entity.min, this.ranger.getMinValue(range), this.comparator);
        int maxPos = Arrays.binarySearch(entity.max, this.ranger.getMaxValue(range), this.comparator);
        if (minPos < 0) {
            minPos = -minPos - 1;
        }
        Object c = entity.min[minPos];
        int size = entity.min.length - 1;
        while (minPos < size && this.comparator.compare(entity.min[minPos + 1], c) == 0) {
            ++minPos;
        }
        if (maxPos < 0) {
            maxPos = -maxPos - 1;
        }
        c = entity.max[maxPos];
        while (maxPos > 0 && this.comparator.compare(entity.max[maxPos - 1], c) == 0) {
            --maxPos;
        }
        Object r = null;
        block2: for (int i = minPos; i >= 0 && this.comparator.compare(this.ranger.getMinValue(r = (Object)entity.ranges[entity.minIndex[i]]), this.ranger.getMinValue(range)) >= 0; --i) {
            int size2 = entity.maxIndex.length;
            for (int j = maxPos; j < size2; ++j) {
                Object r2 = entity.ranges[entity.maxIndex[j]];
                if (this.comparator.compare(this.ranger.getMaxValue(r), this.ranger.getMaxValue(range)) > 0) continue block2;
                if (r != r2 || r != range) continue;
                minPos = i;
                maxPos = j;
                Object[] min = (Object[])Array.newInstance(this.clazz, entity.min.length - 1);
                System.arraycopy(entity.min, 0, min, 0, minPos);
                System.arraycopy(entity.min, minPos + 1, min, minPos, entity.min.length - minPos - 1);
                int[] minIndex = new int[entity.minIndex.length - 1];
                System.arraycopy(entity.minIndex, 0, minIndex, 0, minPos);
                System.arraycopy(entity.minIndex, minPos + 1, minIndex, minPos, entity.minIndex.length - minPos - 1);
                int iiSize = minIndex.length;
                int pos = entity.minIndex[minPos];
                for (int ii = 0; ii < iiSize; ++ii) {
                    if (minIndex[ii] <= pos) continue;
                    int n = ii;
                    minIndex[n] = minIndex[n] - 1;
                }
                Object[] max = (Object[])Array.newInstance(this.clazz, entity.max.length - 1);
                System.arraycopy(entity.max, 0, max, 0, maxPos);
                System.arraycopy(entity.max, maxPos + 1, max, maxPos, entity.max.length - maxPos - 1);
                int[] maxIndex = new int[entity.maxIndex.length - 1];
                System.arraycopy(entity.maxIndex, 0, maxIndex, 0, maxPos);
                System.arraycopy(entity.maxIndex, maxPos + 1, maxIndex, maxPos, entity.maxIndex.length - maxPos - 1);
                int iiSize2 = maxIndex.length;
                int pos2 = entity.maxIndex[maxPos];
                for (int ii = 0; ii < iiSize2; ++ii) {
                    if (maxIndex[ii] <= pos2) continue;
                    int n = ii;
                    maxIndex[n] = maxIndex[n] - 1;
                }
                Object[] ranges = (Object[])Array.newInstance(this.rangeClazz, entity.ranges.length - 1);
                System.arraycopy(entity.ranges, 0, ranges, 0, entity.minIndex[minPos]);
                System.arraycopy(entity.ranges, entity.minIndex[minPos] + 1, ranges, entity.minIndex[minPos], entity.ranges.length - entity.minIndex[minPos] - 1);
                return new Entity(this.ranger, this.comparator, this.rangeClazz, this.clazz, ranges, min, minIndex, max, maxIndex, entity.canRangeInRange);
            }
        }
        return entity;
    }

    public void add(R range) {
        this.lock.lock();
        try {
            if (this.rangeSet.putIfAbsent(range, range) == null) {
                this.entity = this.add(this.entity, range);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Set<R> ranges) {
        this.lock.lock();
        try {
            boolean changed = false;
            for (R range : ranges) {
                if (this.rangeSet.put(range, range) != null) continue;
                changed = true;
            }
            if (changed) {
                this.entity = this.create(this.rangeSet, true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Set<R> ranges) {
        this.lock.lock();
        try {
            this.rangeSet.clear();
            for (R range : ranges) {
                this.rangeSet.put(range, range);
            }
            this.entity = this.create(this.rangeSet, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(R range) {
        this.lock.lock();
        try {
            if (this.rangeSet.remove(range) != null) {
                this.entity = this.remove(this.entity, range);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Set<R> ranges) {
        this.lock.lock();
        try {
            ranges = new HashSet<R>(ranges);
            ranges.retainAll(this.rangeSet.keySet());
            if (this.rangeSet.keySet().removeAll(ranges)) {
                if (ranges.size() >= 100) {
                    this.entity = this.create(this.rangeSet, true);
                } else {
                    Entity entity = this.entity;
                    for (R range : ranges) {
                        entity = this.remove(entity, range);
                    }
                    this.entity = entity;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public R search(C key) {
        Entity entity = this.entity;
        return entity.searchCanIntersect(key);
    }

    public static void main2(String[] args) {
        class RangeLong {
            private final Long minValue;
            private final Long maxValue;

            public RangeLong(long minValue, long maxValue) {
                this.minValue = minValue;
                this.maxValue = maxValue;
            }

            public String toString() {
                return this.minValue + "-" + this.maxValue;
            }
        }
        HashSet<RangeLong> list = new HashSet<RangeLong>();
        Random rand = new Random();
        for (int i = 0; i < 100000; ++i) {
            long l = rand.nextInt(99999999);
            RangeLong r = new RangeLong(l, l + (long)rand.nextInt(999999));
            list.add(r);
        }
    }

    private class Entity {
        final Ranger<R, C> ranger;
        final Comparator<C> comparator;
        final Class<R> rangeClazz;
        final Class<C> clazz;
        final boolean canRangeInRange;
        final R[] ranges;
        final C[] min;
        final int[] minIndex;
        final C[] max;
        final int[] maxIndex;

        Entity(Ranger<R, C> ranger, Comparator<C> comparator, Class<R> rangeClazz, Class<C> clazz, R[] ranges, C[] min, int[] minIndex, C[] max, int[] maxIndex, boolean canIntersect) {
            this.ranger = ranger;
            this.comparator = comparator;
            this.rangeClazz = rangeClazz;
            this.clazz = clazz;
            this.canRangeInRange = canIntersect;
            this.ranges = ranges;
            this.min = min;
            this.minIndex = minIndex;
            this.max = max;
            this.maxIndex = maxIndex;
        }

        public R search(C key) {
            int min = Arrays.binarySearch(this.min, key, this.comparator);
            if (min >= 0) {
                return this.ranges[this.minIndex[min]];
            }
            if (min == -1 || min == -2) {
                return null;
            }
            Object r = this.ranges[this.minIndex[min = -min - 2]];
            if (this.comparator.compare(this.ranger.getMaxValue(r), key) >= 0) {
                return r;
            }
            return null;
        }

        public R searchCanIntersect(C key) {
            int min = Arrays.binarySearch(this.min, key, this.comparator);
            if (min >= 0) {
                return this.ranges[this.minIndex[min]];
            }
            if (min == -1) {
                return null;
            }
            Object r = this.ranges[this.minIndex[min = -min - 2]];
            if (this.comparator.compare(this.ranger.getMaxValue(r), key) >= 0) {
                return r;
            }
            if (--min >= 0) {
                r = this.ranges[this.minIndex[min]];
                if (this.comparator.compare(this.ranger.getMaxValue(r), key) >= 0) {
                    return r;
                }
            } else {
                return null;
            }
            int max = Arrays.binarySearch(this.max, key, this.comparator);
            if (max >= 0) {
                return this.ranges[this.maxIndex[max]];
            }
            if (max == -1) {
                return null;
            }
            max = -max - 1;
            int index = this.minIndex[min];
            int size = this.maxIndex.length;
            for (int j = max; j < size; ++j) {
                if (index != this.maxIndex[j]) continue;
                return this.ranges[min];
            }
            for (int i = --min; i >= 0; --i) {
                int index2 = this.minIndex[i];
                int size2 = this.maxIndex.length;
                for (int j = max; j < size2; ++j) {
                    if (index2 != this.maxIndex[j]) continue;
                    return this.ranges[index2];
                }
            }
            return null;
        }

        protected R search2(C key) {
            int min = Arrays.binarySearch(this.min, key, this.comparator);
            if (min >= 0) {
                return this.ranges[this.minIndex[min]];
            }
            if (min == -1 || min == -2) {
                return null;
            }
            Object r = this.ranges[this.minIndex[min = -min - 2]];
            if (this.comparator.compare(this.ranger.getMaxValue(r), key) >= 0) {
                return r;
            }
            if (--min >= 0) {
                r = this.ranges[this.minIndex[min]];
                if (this.comparator.compare(this.ranger.getMinValue(r), key) < 0) {
                    return null;
                }
            } else {
                return null;
            }
            int max = Arrays.binarySearch(this.max, key, this.comparator);
            if (max >= 0) {
                return this.ranges[this.maxIndex[max]];
            }
            if (max == -1) {
                return null;
            }
            int size = this.maxIndex.length;
            for (int j = max = -max - 1; j < size; ++j) {
                Object r2 = this.ranges[this.maxIndex[j]];
                if (this.comparator.compare(this.ranger.getMaxValue(r), key) > 0) break;
                if (r != r2) continue;
                return r;
            }
            block1: for (int i = --min; i >= 0 && this.comparator.compare(this.ranger.getMinValue(r = this.ranges[this.minIndex[i]]), key) >= 0; --i) {
                int size2 = this.maxIndex.length;
                for (int j = max; j < size2; ++j) {
                    Object r2 = this.ranges[this.maxIndex[j]];
                    if (this.comparator.compare(this.ranger.getMaxValue(r), key) > 0) continue block1;
                    if (r != r2) continue;
                    return r;
                }
            }
            return null;
        }
    }

    private class Entry {
        final int index;
        final C c;

        public Entry(int index, C c) {
            this.index = index;
            this.c = c;
        }
    }
}

