/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ru.bitel.common.Utils;

public class BGControlPanelButtonGroup
extends JPanel {
    private ButtonGroup buttonGroup = null;
    private Map<String, JToggleButton> buttons = new HashMap<String, JToggleButton>();

    public BGControlPanelButtonGroup() {
        this(true);
    }

    public BGControlPanelButtonGroup(boolean grupped) {
        this.setLayout(new GridBagLayout());
        if (grupped) {
            this.buttonGroup = new ButtonGroup();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        for (JToggleButton button : this.buttons.values()) {
            button.addActionListener(actionListener);
        }
    }

    public String getSelectedCommand() {
        if (this.buttonGroup != null) {
            return this.buttonGroup.getSelection() != null ? this.buttonGroup.getSelection().getActionCommand() : null;
        }
        return Utils.toString(this.getSelectedCommands());
    }

    public List<String> getSelectedCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (JToggleButton button : this.buttons.values()) {
            if (!button.isSelected()) continue;
            commands.add(button.getActionCommand());
        }
        return commands;
    }

    public void addButton(String title, String command, boolean selected) {
        JToggleButton button = new JToggleButton(title, selected);
        button.setActionCommand(command);
        if (this.buttonGroup != null) {
            this.buttonGroup.add(button);
        }
        this.add((Component)button, new GridBagConstraints(this.buttons.size(), 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttons.put(command, button);
    }

    public void addButton(String title, String command) {
        this.addButton(title, command, false);
    }

    public void setSelectedCommand(String command) {
        try {
            this.buttons.get(command).setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

