/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.dto.EntitySpecDTO;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntitySpecPanel
extends BGUPanel {
    private EntitySpecTableModel model = new EntitySpecTableModel();
    private EntityService entityService = null;

    public EntitySpecPanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(table, this);
    }

    private EntityService getEntityService() {
        if (this.entityService == null) {
            this.entityService = ((ClientContext)this.getContext()).getPort(EntityService.class);
        }
        return this.entityService;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> Async.of(() -> this.model.setData(this.getEntityService().entitySpecDtoList())));
        new AbstractBGUPanel.BGActionNew(e -> new EntitySpecEditor("\u041d\u043e\u0432\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432", new EntitySpec()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.model.optSelectedRow().ifPresentOrElse(a -> {
            try {
                EntitySpec entitySpec = this.getEntityService().entitySpecGet(a.getId());
                this.showEditDialog(entitySpec, EntitySpecEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete(e -> ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u0442.\u043a. \u043d\u0430\u0431\u043e\u0440 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044f\u043c \u043c\u043e\u0434\u0443\u043b\u044f."));
    }

    public class EntitySpecTableModel
    extends BGTableModel<EntitySpecDTO> {
        public EntitySpecTableModel() {
            super(EntitySpecTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 160, 300, 400, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f", 160, 160, -1, "entityTitleMacros", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class EntitySpecEditor
    extends BGEditorDialog<EntitySpec> {
        private BGUList<AbstractSpecAttr> selectAttr;
        private BGUList<AbstractSpecAttr> avaiblAttr;
        private BGTextField title;
        private JTextArea titleMacros;
        private JTextArea comment;

        public EntitySpecEditor(String title, EntitySpec data) {
            super(title, data);
            this.selectAttr = new BGUList();
            this.avaiblAttr = new BGUList();
            this.title = new BGTextField(50);
            this.titleMacros = new JTextArea(3, 50);
            this.comment = new JTextArea(3, 50);
        }

        @Override
        public void doDialogPanel() {
            DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    EntitySpecAttr entitySpecAttr = (EntitySpecAttr)value;
                    JLabel component = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    component.setText(entitySpecAttr.getTitle() + " [" + entitySpecAttr.getTypeName() + "]");
                    return component;
                }
            };
            this.selectAttr.setCellRenderer(listCellRenderer);
            this.avaiblAttr.setCellRenderer(listCellRenderer);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.titleMacros), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)this.getAttrListPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.title.setText(((EntitySpec)this.data).getTitle());
            this.titleMacros.setText(((EntitySpec)this.data).getEntityTitleMacros());
            this.comment.setText(((EntitySpec)this.data).getComment());
            HashSet<Object> selectSet = new HashSet<Object>();
            ArrayList<AbstractSpecAttr> selectListModel = new ArrayList<AbstractSpecAttr>();
            if (((EntitySpec)this.data).getAttributeList() != null) {
                for (Object entitySpecAttr : ((EntitySpec)this.data).getAttributeList()) {
                    selectListModel.add((AbstractSpecAttr)entitySpecAttr);
                    selectSet.add(entitySpecAttr);
                }
            }
            this.selectAttr.setData(selectListModel);
            ArrayList<EntitySpecAttr> avaibleListModel = new ArrayList<EntitySpecAttr>();
            try {
                for (EntitySpecAttr entitySpecAttr : EntitySpecPanel.this.getEntityService().entitySpecAttrList()) {
                    if (selectSet.contains(entitySpecAttr)) continue;
                    avaibleListModel.add(entitySpecAttr);
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            this.avaiblAttr.setData(avaibleListModel);
        }

        private JPanel getAttrListPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getSelectPanel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b:", this.selectAttr), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getButtonPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            panel.add((Component)this.getSelectPanel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b:", this.avaiblAttr), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSelectPanel(String title, JList<AbstractSpecAttr> list) {
            Dimension dimension = new Dimension(400, 300);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.add((Component)new JLabel(title), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getButtonPanel() {
            JButton addButton = new JButton("<<<");
            JButton delButton = new JButton(">>>");
            addButton.addActionListener(new MoveEntitySpecAttr(this.avaiblAttr, this.selectAttr));
            delButton.addActionListener(new MoveEntitySpecAttr(this.selectAttr, this.avaiblAttr));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel(" "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            ArrayList<AbstractSpecAttr> attrs = new ArrayList<AbstractSpecAttr>();
            ListModel listModel = this.selectAttr.getModel();
            for (int index = 0; index < listModel.getSize(); ++index) {
                attrs.add((AbstractSpecAttr)listModel.getElementAt(index));
            }
            ((EntitySpec)this.data).setTitle(this.title.getText());
            ((EntitySpec)this.data).setEntityTitleMacros(this.titleMacros.getText());
            ((EntitySpec)this.data).setComment(this.comment.getText());
            ((EntitySpec)this.data).setAttributeList(attrs);
            int id = EntitySpecPanel.this.getEntityService().entitySpecUpdate((EntitySpec)this.data);
            EntitySpecPanel.this.performAction("refresh");
            EntitySpecPanel.this.model.setSelectedRow(id);
            return true;
        }
    }

    class MoveEntitySpecAttr
    implements ActionListener {
        private BGUList<AbstractSpecAttr> from;
        private BGUList<AbstractSpecAttr> to;

        MoveEntitySpecAttr(BGUList<AbstractSpecAttr> from, BGUList<AbstractSpecAttr> to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AbstractSpecAttr entitySpecAttr : this.from.getSelectedValuesList()) {
                ((DefaultListModel)this.to.getModel()).addElement(entitySpecAttr);
                ((DefaultListModel)this.from.getModel()).removeElement(entitySpecAttr);
            }
        }
    }
}

