/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.client;

import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractData;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.bgbilling.modules.mobile.common.bean.PushStatusType;
import ru.bitel.bgbilling.modules.mobile.common.service.MobileService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class PushNotificationsPanel
extends BGUPanel {
    private JTextPane statusLabel = new JTextPane();
    private BGTableModel<MobileContractNotification> model;
    private BGUTable table = new BGUTable(this.model);
    private JCheckBox storableCheckBox = new JCheckBox("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f:");
    private BGTextArea textEditor = new BGTextArea(20, 20);
    private JPanel editor = new JPanel(new GridBagLayout());
    private MobileService mobileService = null;
    private Directory<UserInfo> userDirectory = null;
    private MobileContractData mobData = null;
    private int contractId;

    protected void jbInit() throws Exception {
        this.contractId = ((ClientContext)this.getContext()).getContractId();
        this.model = new BGTableModel<MobileContractNotification>("\u0423\u0441\u043b\u0443\u0433\u0438"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 150, 200, "status", true);
                this.addColumn("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", -1, 150, 200, "dateSend", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e", -1, 150, 200, "dateConfirm", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u0425\u0440\u0430\u043d\u0438\u043c\u044b\u0439", -1, 150, 200, "storable", true);
                this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, 150, 400, "user", true);
                this.addColumn("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "text", true);
            }

            public Object getValueAt(MobileContractNotification val, int column) throws Exception {
                switch (column) {
                    case 1: {
                        return val.getStatus().toString();
                    }
                    case 5: {
                        return PushNotificationsPanel.this.userDirectory.get(val.getUserId()) == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((UserInfo)PushNotificationsPanel.this.userDirectory.get(val.getUserId())).getName();
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table.setModel(this.model);
        this.statusLabel.setEditable(false);
        this.statusLabel.setBorder(null);
        this.statusLabel.setBackground(null);
        this.statusLabel.setContentType("text/html");
        this.setLayout(new GridBagLayout());
        this.add(this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        okCancel.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                this.sendNotification();
            } else {
                this.editor.setVisible(false);
            }
        });
        JScrollPane scrollText = new JScrollPane((Component)this.textEditor);
        scrollText.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0422\u0435\u043a\u0441\u0442"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        this.editor.add((Component)this.storableCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)scrollText, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        this.add(this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.setVisible(false);
    }

    private void sendNotification() {
        if (Utils.isBlankString((String)this.textEditor.getText())) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0443\u0441\u0442\u043e\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435!");
            return;
        }
        if (ClientUtils.confirm((String)"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 ?", (String)"\u041e\u0442\u0441\u044b\u043b\u043a\u0430 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f")) {
            MobileContractNotification notification = new MobileContractNotification();
            notification.setContractId(this.contractId);
            notification.setText(this.textEditor.getText());
            notification.setStorable(this.storableCheckBox.isSelected());
            try {
                this.mobileService.sendPushNotification(notification);
                this.performAction("refresh");
                this.editor.setVisible(false);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.mobileService == null || e.getActionCommand() == "refresh") {
                this.mobileService = (MobileService)((ClientContext)this.getContext()).getPort(MobileService.class);
                this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class, 0);
            }
            Object text = "<html><body><pre><b> \u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b! \u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f </b></pre></body></html>";
            this.mobData = this.mobileService.getMobileContractData(this.contractId);
            if (this.mobData != null) {
                text = "<html><body><pre><b>\u0421\u0442\u0430\u0442\u0443\u0441:</b> " + (Serializable)((Object)(PushStatusType.statusIsReachable((PushStatusType)this.mobData.getStatus()) ? "\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439" : this.mobData.getStatus()));
                text = (String)text + "   <b>\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435:</b> " + TimeUtils.formatFullDate((Date)this.mobData.getLastConfirmDate());
                text = (String)text + "   <b>\u041a\u043e\u043b-\u0432\u043e \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0439:</b> " + this.mobData.getCountNotification() + "   <b>\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435:</b> " + TimeUtils.formatFullDate((Date)this.mobData.getLastSendDate()) + "</pre></body></html>";
            }
            this.statusLabel.setText((String)text);
            this.model.setData(this.mobileService.contractNotifications(this.contractId, null, null, null));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.mobData == null || !PushStatusType.statusIsReachable((PushStatusType)this.mobData.getStatus())) {
                JOptionPane.showMessageDialog((Component)((Object)this), "\u0414\u0430\u043d\u043d\u043e\u043c\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435", "\u041e\u0448\u0438\u0431\u043a\u0430", 1);
                return;
            }
            this.textEditor.setText("");
            this.storableCheckBox.setSelected(true);
            this.editor.setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> ClientUtils.showErrorMessageDialog((String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            List removeList = this.model.getSelectedRows();
            if (removeList.size() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d-(\u0438\u0435/\u0438\u044f)!");
                return;
            }
            if (ClientUtils.confirm((String)("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (String)(removeList.size() > 1 ? removeList.size() + " \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f?" : "\u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435?")), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                for (MobileContractNotification notification : removeList) {
                    this.mobileService.deleteContractNotification(notification.getId());
                }
                this.model.setData(this.mobileService.contractNotifications(this.contractId, null, null, null));
            }
        });
    }
}

