/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.phone.common.bean.GateType;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class GateTypeManager {
    private String table = null;
    protected int mid = -1;
    protected Connection con;

    public GateTypeManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
        this.table = "phone_gate_type_" + mid;
    }

    public List<GateType> list() throws BGException {
        ArrayList<GateType> result = new ArrayList<GateType>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  * from  " + this.table);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GateType type = this.getFromRS(rs);
                result.add(type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private GateType getFromRS(ResultSet rs) throws SQLException {
        GateType result = new GateType();
        result.setId(rs.getInt("id"));
        result.setComment(rs.getString("comment"));
        result.setTitle(rs.getString("title"));
        result.setConfig(rs.getString("config"));
        result.setScript(rs.getString("script"));
        return result;
    }

    public void update(GateType type) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            String setPart = " SET  comment = ?, title = ?, config = ?, script = ? ";
            if (type.getId() > 0) {
                query.append(" UPDATE  " + this.table);
                query.append(setPart);
                query.append(" WHERE id = ?  ");
            } else {
                query.append(" INSERT INTO   " + this.table);
                query.append(setPart);
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            int idx = 1;
            ps.setString(idx++, type.getComment());
            ps.setString(idx++, type.getTitle());
            ps.setString(idx++, type.getConfig());
            ps.setString(idx++, type.getScript());
            if (type.getId() > 0) {
                ps.setInt(idx++, type.getId());
            }
            ps.executeUpdate();
            if (type.getId() == 0) {
                type.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public GateType getTypeById(int id) throws BGException {
        GateType result = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT  * from  " + this.table);
            query.append(" WHERE id = ? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public void delete(int id) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append(" DELETE FROM  " + this.table);
            query.append(" WHERE id = ?  ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getTable() {
        return this.table;
    }
}

