/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CDRFieldMapper {
    private static final Logger log = LogManager.getLogger();
    private final JSONArray cdrSettings;
    private final Map<String, JSONObject> cdrSettingsMap = new HashMap<String, JSONObject>();

    public CDRFieldMapper(SormProject sormProject) {
        this(sormProject.getLoadedConfig());
    }

    public CDRFieldMapper(Preferences config) {
        this.cdrSettings = new JSONArray(config.get("sorm.upload.cdr.config", "[]"));
        for (int i = 0; i < this.cdrSettings.length(); ++i) {
            JSONObject json = this.cdrSettings.getJSONObject(i);
            this.cdrSettingsMap.put(json.optString("configKey"), json);
        }
    }

    public String collate(String configKey, String[] line) {
        if (Utils.isBlankString((String)configKey)) {
            return "";
        }
        int position = Utils.parseInt((String)this.cdrSettingsMap.getOrDefault(configKey, new JSONObject()).optString("value"), (int)-1);
        if (position >= line.length) {
            log.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u0430 \u043f\u043e\u043b\u0435\u0439 CDR! \u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043a\u043e\u043b-\u0432\u0430 \u043f\u043e\u043b\u0435\u0439 \u0432 CDR \u0437\u0430\u043f\u0438\u0441\u0438! \u0414\u043b\u044f \u043a\u043b\u044e\u0447\u0430=" + configKey);
            return "";
        }
        if (position < 0) {
            String customValue = this.cdrSettingsMap.getOrDefault(configKey, new JSONObject()).optString("customValue");
            if (Utils.isBlankString((String)customValue)) {
                return "";
            }
            return customValue;
        }
        return line[position];
    }

    public CDRItem fieldsToCDRItem(String[] fields, int voiceDeviceId) {
        CDRItem item = new CDRItem();
        item.contractId = Utils.parseInt((String)this.collate("sorm.upload.cdr.cid", fields));
        long time = Utils.parseLong((String)this.collate("sorm.upload.cdr.calldate", fields), (long)-1L);
        if (time > 0L) {
            item.startTime = new Date(time);
        } else {
            String date = String.valueOf(this.collate("sorm.upload.cdr.calldate", fields));
            item.startTime = TimeUtils.parseDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        item.duration = Utils.parseLong((String)this.collate("sorm.upload.cdr.callduration", fields));
        item.callingNumber = String.valueOf(this.collate("sorm.upload.cdr.callingnumber", fields));
        item.calledNumber = String.valueOf(this.collate("sorm.upload.cdr.callednumber", fields));
        item.callType = Utils.parseInt((String)this.collate("sorm.upload.cdr.calltype", fields));
        item.fromPort = String.valueOf(this.collate("sorm.upload.cdr.bunch.from", fields));
        item.toPort = String.valueOf(this.collate("sorm.upload.cdr.bunch.to", fields));
        item.deviceId = Utils.parseInt((String)this.collate("sorm.upload.cdr.commutatorid", fields), (int)voiceDeviceId);
        item.otherInfo = fields;
        item.id = String.valueOf(this.collate("sorm.upload.cdr.callid", fields));
        if (Utils.isBlankString((String)item.id)) {
            item.id = this.generateCallId(item);
        }
        return item;
    }

    private String generateCallId(CDRItem cdrItem) {
        Calendar c = Calendar.getInstance();
        c.setTime(cdrItem.startTime != null ? cdrItem.startTime : new Date());
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        return cdrItem.callingNumber + (hour * minute + second);
    }
}

