/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bean;

import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.VkApiClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;

public class VKApiHelper {
    private VkApiClient apiClient;
    private final String apiEndpoint;
    private final String apiVersionParam;
    public static final String GET_MESSAGES_UPLOAD_SERVER = "photos.getMessagesUploadServer?";
    public static final String POST_UPLOAD_IMAGE = "photos.saveMessagesPhoto?";
    public static final String GET_DOC_UPLOAD_SERVER = "docs.getMessagesUploadServer?";
    public static final String POST_UPLOAD_DOC = "docs.save?";

    public VKApiHelper(VkApiClient apiClient) {
        this.apiClient = apiClient;
        this.apiEndpoint = apiClient.getApiEndpoint();
        this.apiVersionParam = "v=" + apiClient.getVersion() + "&";
    }

    public JSONObject doGet(String method, HashMap<String, String> params) throws BGException {
        JSONObject response;
        try {
            String requestParams = this.requestParams(params);
            response = this.preProcessResponse(this.apiClient.getTransportClient().get(this.apiEndpoint + method + this.apiVersionParam + requestParams));
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        return response;
    }

    public JSONObject doPost(String method, HashMap<String, String> params) throws BGException {
        JSONObject response;
        try {
            String requestParams = this.requestParams(params);
            String url = this.apiEndpoint + method + this.apiVersionParam + requestParams;
            response = this.preProcessResponse(this.apiClient.getTransportClient().post(url));
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        return response;
    }

    public JSONObject uploadAttachmentFileOnVKServer(String url, File file) throws BGException {
        JSONObject resp;
        HttpPost httpPostLink = new HttpPost(url);
        HttpEntity httpEntity = MultipartEntityBuilder.create().setLaxMode().setStrictMode().addBinaryBody("file", file, ContentType.MULTIPART_FORM_DATA, file.getName()).build();
        httpPostLink.setEntity(httpEntity);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPostLink);
            resp = new JSONObject(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        return resp;
    }

    private String requestParams(HashMap<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String paramKey : params.keySet()) {
            sb.append(paramKey).append("=").append(params.get(paramKey)).append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private JSONObject preProcessResponse(ClientResponse clientResponse) {
        if (clientResponse == null) {
            return new JSONObject();
        }
        return new JSONObject(clientResponse.getContent());
    }
}

