/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.drecrypt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.base.server.util.SequentialIdManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.drecrypt.DreException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DreCryptCon
extends BGLogger {
    private String driver;
    private String url;
    private String login;
    private String password;
    private int INFOCAS_PERIOD;
    private int INFOCAS_INTERVAL;
    private int CAS_VERSION;
    private int DEVICE_MODEL_ID;
    private Connection con;
    private SequentialIdManager sequentialIdManager;
    private String sessionTz;
    private List<Long> IDS = new ArrayList<Long>();
    private int waitForResultTimeout = -1;

    public DreCryptCon(ParameterMap connectionSetup, int serverId, SequentialIdManager sequentialIdManager) throws BGException {
        this.driver = connectionSetup.get("driver", "oracle.jdbc.OracleDriver");
        this.url = connectionSetup.get("url", null);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new BGException("Driver class " + this.driver + " not found");
        }
        if (Utils.isBlankString((String)this.url)) {
            throw new BGException("Url server " + serverId + " undefined (\"jdbc:oracle:thin:@//host:port/database\")");
        }
        this.login = connectionSetup.get("login", null);
        this.password = connectionSetup.get("password", null);
        this.INFOCAS_PERIOD = connectionSetup.getInt("INFOCAS_PERIOD", 20);
        this.INFOCAS_INTERVAL = connectionSetup.getInt("INFOCAS_INTERVAL", 5);
        this.CAS_VERSION = connectionSetup.getInt("CAS_VERSION", 3);
        this.DEVICE_MODEL_ID = connectionSetup.getInt("DEVICE_MODEL_ID", -1);
        this.waitForResultTimeout = connectionSetup.getInt("wait.result.timeout", -1);
        this.sequentialIdManager = sequentialIdManager;
        this.sessionTz = connectionSetup.get("session.tz", null);
    }

    public void connect() throws BGException {
        try {
            this.con = DriverManager.getConnection(this.url, this.login, this.password);
        }
        catch (SQLException e) {
            this.processSQLException("error sql-connection to " + this.url, e);
        }
        this.initSession();
    }

    private void processSQLException(String message, SQLException e) throws BGException {
        throw new BGException(message + " (" + e.getErrorCode() + "/" + e.getMessage() + ")", (Throwable)e);
    }

    public void disconnect() throws SQLException {
        if (this.con != null) {
            this.con.commit();
            this.con.close();
        }
    }

    public List<DreSubscriptionInfo> getSubscriptionCurrentState(long HARDWARE_ID) throws SQLException {
        ArrayList<DreSubscriptionInfo> result = new ArrayList<DreSubscriptionInfo>();
        long NOW = System.currentTimeMillis() / 1000L;
        String query = "SELECT * FROM CURRENT_STATE WHERE HARDWARE_ID=? ORDER BY CLASS_ID";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, String.valueOf(HARDWARE_ID));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String S_HARDWARE_ID = rs.getString("HARDWARE_ID");
            int CLASS_ID = rs.getInt("CLASS_ID");
            long STARTSEC = rs.getLong("STARTSEC");
            long STOPSEC = rs.getLong("STOPSEC");
            if (STOPSEC < NOW) continue;
            result.add(new DreSubscriptionInfo(Long.parseLong(S_HARDWARE_ID), CLASS_ID, new Date(STARTSEC * 1000L), new Date(STOPSEC * 1000L)));
        }
        ps.close();
        return result;
    }

    private void initSession() throws BGException {
        try {
            if (this.sessionTz != null) {
                String query = "alter session set time_zone='" + this.sessionTz + "'";
                Statement ps = this.con.createStatement();
                ps.executeUpdate(query);
                ps.close();
            }
        }
        catch (SQLException e) {
            this.processSQLException("error sql-init-session", e);
        }
    }

    private void insertTable(Map<String, Object> values, String commandTitle) throws BGException {
        long ID = this.generateID();
        try {
            values.put("ID", ID);
            this.IDS.add(ID);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("run command \"" + commandTitle + "\", HARDWARE_ID=\"" + values.getOrDefault("HARDWARE_ID", "<NONE>") + "\", TQUEUE-ID=" + ID);
            }
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> quests = new ArrayList<String>();
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Map.Entry<String, Object> e : values.entrySet()) {
                fields.add(e.getKey());
                quests.add("?");
                objects.add(e.getValue());
            }
            String query = "INSERT INTO TQUEUE (" + Utils.toString(fields) + ") VALUES (" + Utils.toString(quests) + ")";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("execute query: " + query);
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            for (Object e : objects) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("insert: " + e);
                }
                if (e instanceof Date) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)((Date)e)));
                    continue;
                }
                ps.setObject(index++, e);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.processSQLException("error sql-insert-table (command \"" + commandTitle + "\", TQUEUE-ID=" + ID + ")", e);
        }
    }

    public void sendBroadcastInfocas(final String message) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("INFOCAS_PERIOD", DreCryptCon.this.INFOCAS_PERIOD);
                this.put("INFOCAS_INTERVAL", DreCryptCon.this.INFOCAS_INTERVAL);
                this.put("INFOCAS_MESSAGE_TEXT", message);
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 19);
                this.put("CAS_VERSION", DreCryptCon.this.CAS_VERSION);
            }
        }, "sendBroadcastInfocas");
    }

    public void sendPersonalInfocas(final long HARDWARE_ID, final String message) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("HARDWARE_ID", String.valueOf(HARDWARE_ID));
                this.put("INFOCAS_PERIOD", DreCryptCon.this.INFOCAS_PERIOD);
                this.put("INFOCAS_INTERVAL", DreCryptCon.this.INFOCAS_INTERVAL);
                this.put("INFOCAS_MESSAGE_TEXT", message);
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 20);
                this.put("CAS_VERSION", DreCryptCon.this.CAS_VERSION);
            }
        }, "sendPersonalInfocas");
    }

    private long generateID() throws BGException {
        return this.sequentialIdManager.generateSequentialId();
    }

    public void waitForResult() throws BGException, DreException {
        if (this.IDS.isEmpty()) {
            return;
        }
        if (this.waitForResultTimeout == -1) {
            return;
        }
        long stopTime = System.currentTimeMillis() + (long)this.waitForResultTimeout * 1000L;
        String _idList = Utils.toString(this.IDS);
        while (System.currentTimeMillis() < stopTime) {
            HashMap<Long, Integer> IDSSTATUS = new HashMap<Long, Integer>();
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("check status for " + this.IDS.size() + " IDs...");
                }
                String query = "SELECT * FROM TQUEUE WHERE ID IN (" + _idList + ") ORDER BY ID";
                Statement ps = this.con.createStatement();
                ResultSet rs = ps.executeQuery(query);
                while (rs.next()) {
                    long ID = rs.getLong("ID");
                    int STATUS = rs.getInt("STATUS");
                    IDSSTATUS.put(ID, STATUS);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                this.processSQLException("error sql-select-table for check STATUS for TQUEUE-IDS=" + _idList, e);
            }
            if (DreException.checkAndGenerateError(IDSSTATUS)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("check status is OK");
                }
                return;
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        throw new BGException("\u0417\u0430 \u043e\u0442\u0432\u0435\u0434\u0451\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f (" + this.waitForResultTimeout + " \u0441\u0435\u043a) \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043a\u0430\u043a\u0438\u0435-\u0442\u043e \u0438\u0437 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043a\u043e\u043c\u0430\u043d\u0434 TQUEUE-IDS:" + _idList);
    }

    public void addSubscription(final long HARDWARE_ID, final int CLASS_ID, final Date date1, final Date date2) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("HARDWARE_ID", String.valueOf(HARDWARE_ID));
                this.put("CLASS_ID", CLASS_ID);
                this.put("DATETIME", date1);
                this.put("ENDDATE", date2);
                if (DreCryptCon.this.DEVICE_MODEL_ID != -1) {
                    this.put("DEVICE_MODEL_ID", DreCryptCon.this.DEVICE_MODEL_ID);
                }
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 1);
            }
        }, "addSubscription");
    }

    public void deleteSubscription(final long HARDWARE_ID, final int CLASS_ID) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("HARDWARE_ID", String.valueOf(HARDWARE_ID));
                this.put("CLASS_ID", CLASS_ID);
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 2);
            }
        }, "deleteSubscription");
    }

    public void deleteSubscriptionAll(final long HARDWARE_ID) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("HARDWARE_ID", String.valueOf(HARDWARE_ID));
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 2);
            }
        }, "deleteSubscriptionAll");
    }

    public void retrySubscription(final long HARDWARE_ID) throws BGException {
        this.insertTable((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("HARDWARE_ID", String.valueOf(HARDWARE_ID));
                this.put("DATEADDED", new Date());
                this.put("STATUS", 0);
                this.put("ACTION", 3);
            }
        }, "retrySubscription");
    }

    public static class DreSubscriptionInfo {
        public long HARDWARE_ID;
        public int CLASS_ID;
        public Date STARTSEC;
        public Date STOPSEC;

        public DreSubscriptionInfo(long HARDWARE_ID, int CLASS_ID, Date STARTSEC, Date STOPSEC) {
            this.HARDWARE_ID = HARDWARE_ID;
            this.CLASS_ID = CLASS_ID;
            this.STARTSEC = STARTSEC;
            this.STOPSEC = STOPSEC;
        }

        public static String getHeader() {
            return "HARDWARE_ID | CLASS_ID | STARTSEC | STOPSEC";
        }

        public String toString() {
            try {
                return String.format("%s | %s | %s | %s", this.HARDWARE_ID, this.CLASS_ID, TimeUtils.formatFullDate((Date)this.STARTSEC), TimeUtils.formatFullDate((Date)this.STOPSEC));
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }
    }
}

