/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.service;

import jakarta.activation.DataHandler;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentStatusDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.event.DocumentGeneratedEvent;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentsPatternGenerator;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.plugins.documents.server.mail.MailSendDocumentLinkFiles;
import ru.bitel.bgbilling.plugins.documents.server.mail.MailSendFile;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService")
public class DocumentsServiceImpl
extends AbstractService
implements DocumentsService {
    private DocumentDao documentDao;
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");
    @Resource
    DocumentsPatternService documentsPatternService;

    @PostConstruct
    public void init() throws Exception {
        this.documentDao = new DocumentDao(this.getConnection());
    }

    private FileStorage getFileStorage() throws Exception {
        return new DocumentsFileStorage(this.getConnection());
    }

    public List<Document> getDocumentList(int contractId, String title, Period period) throws Exception {
        return this.documentDao.getDocumentList(contractId, title, period);
    }

    public Document getDocument(int documentId) throws Exception {
        return this.documentDao.getDocument(documentId);
    }

    public int updateDocument(Document document) throws Exception {
        try {
            document.setUserId(this.userId);
            this.documentDao.update(document);
            return document.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteDocument(List<Integer> documentIds) throws Exception {
        try {
            for (Integer id : documentIds) {
                FileStorage documentsFileStorage = this.getFileStorage();
                documentsFileStorage.deleteByOwner(id.intValue());
                this.documentDao.deleteDocument(id);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean updateDocumentStatus(int documentId, int statusId, String statusComment) throws Exception {
        boolean result = false;
        DocumentStatusLogItem logItem = DocumentStatusLogItem.builder().setStatusId(statusId).setComment(statusComment).setStatusDate(new Date()).setDocumentId(documentId).setUserId(this.context.getUserId()).build();
        List<DocumentStatusLogItem> logList = this.getDocumentStatusLogList(documentId);
        DocumentStatusLogItem lastLogItem = null;
        if (!logList.isEmpty()) {
            lastLogItem = logList.get(logList.size() - 1);
        }
        if (lastLogItem == null || !lastLogItem.equals((Object)logItem)) {
            Document document = this.getDocument(documentId);
            document.setStatusId(statusId);
            this.updateDocument(document);
            this.updateStatusLog(logItem);
            result = true;
        }
        return result;
    }

    public String getAdditionalParams(int contractId) throws Exception {
        JSONObject result = new JSONObject();
        ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
        Contract contract = (Contract)contractDao.get(contractId);
        contractDao.close();
        for (ParameterMap params : this.plugin.getSetup().subKeyed("contract.type.").values()) {
            Pattern pattern;
            Matcher m;
            String extractRegexp;
            String prefix = params.get("prefix", null);
            if (!Utils.notBlankString((String)prefix) || !contract.getTitle().startsWith(prefix)) continue;
            String dir = params.get("dir", null);
            if (Utils.isBlankString((String)dir) || Utils.isBlankString((String)(extractRegexp = params.get("extract.regexp", "\\d+"))) || !(m = (pattern = Pattern.compile(extractRegexp)).matcher(contract.getTitle())).find()) break;
            String create = params.get("dir.auto.create", "false");
            String regexp = params.get("compare.regexp", "<EXTRACT>").replaceAll("<EXTRACT>", m.group(1));
            result.put("dir", (Object)dir);
            result.put("regexp", (Object)regexp);
            result.put("create", (Object)create);
            if (!"true".equals(create)) continue;
            result.put("file", (Object)((String)(dir.endsWith(String.valueOf(File.separatorChar)) ? dir : dir + File.separatorChar) + m.group(1) + " " + contract.getComment()));
        }
        return result.toString();
    }

    public List<BGServerFile> getDocumentFileList(int documentId) throws Exception {
        return this.getFileStorage().getFilesListByOwner(documentId);
    }

    public BGServerFile downloadDocumentFile(int fileId, int contractId, Holder<DataHandler> fileData) throws Exception {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        FileStorage documentsFileStorage = this.getFileStorage();
        BGServerFile serverFile = documentsFileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        serverFile.setContractId(this.documentDao.getDocumentOwnerId(serverFile.getOwnerId()));
        if (serverFile.getContractId() != contractId) {
            throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; cid = " + contractId + "; file_cid = " + serverFile.getContractId());
        }
        try {
            File file = new File(documentsFileStorage.getFileName(fileId));
            if (!file.exists()) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).", (Throwable)new FileNotFoundException());
            }
            fileData.value = new DataHandler(documentsFileStorage.getDataSource(fileId));
        }
        catch (FileNotFoundException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
        }
        return serverFile;
    }

    public void deleteDocumentFiles(List<Integer> fileIds) throws Exception {
        if (fileIds == null) {
            throw new BGIllegalArgumentException();
        }
        FileStorage documentsFileStorage = this.getFileStorage();
        String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
        if (!Utils.isEmptyString((String)rootPath)) {
            for (Integer fileId : fileIds) {
                BGServerFile serverFile = documentsFileStorage.getFileById(fileId.intValue());
                String fileExtension = serverFile.getTitle().substring(serverFile.getTitle().lastIndexOf(".") + 1);
                documentsFileStorage.deleteFile(fileId.intValue(), fileExtension);
            }
        } else {
            for (Integer fileId : fileIds) {
                documentsFileStorage.deleteFile(fileId.intValue());
            }
        }
    }

    public void updateDocumentFile(BGServerFile file) throws Exception {
        this.getFileStorage().updateFile(file);
    }

    public void sendFileByEmail(List<String> emails, List<Integer> fileIds) throws Exception {
        MailData mailData = new MailSendFile().setRecipients(Utils.toString(emails, (String)"\n")).setSubject(this.plugin.getSetup().get("documents.mail.subject", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 BGBilling"));
        try {
            int count = 1;
            for (Integer id : fileIds) {
                FileStorage documentsFileStorage = this.getFileStorage();
                try {
                    documentsFileStorage.load(id.intValue());
                }
                catch (IOException ex) {
                    BGLogger.error((Throwable)ex);
                    throw new BGMessageException("\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b. \u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435.");
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                outputStream.write(documentsFileStorage.load(id.intValue()).readAllBytes());
                mailData.addPart("file" + count++, "attachment", "application/octet-stream", documentsFileStorage.getFileById(id.intValue()).getTitle(), outputStream.toByteArray());
            }
            new MailMsg((Preferences)Setup.getSetup()).sendMessage(mailData);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<DocumentJournal> documentJournalList() throws Exception {
        return this.context.getDirectory(DocumentJournal.class, -1).list();
    }

    public DocumentJournal documentJournalGet(int journalId) throws Exception {
        return (DocumentJournal)this.context.getDirectory(DocumentJournal.class, -1).get(journalId);
    }

    public int documentJournalUpdate(DocumentJournal journal) throws Exception {
        try {
            this.context.getDirectory(DocumentJournal.class, -1).update((Id)journal);
            return journal.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int documentJournalDelete(int journalId) throws Exception {
        try {
            return this.context.getDirectory(DocumentJournal.class, -1).delete(journalId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<DocumentType> documentTypeList() throws Exception {
        return this.context.getDirectory(DocumentType.class, -1).list();
    }

    public DocumentType documentTypeGet(int typeId) throws Exception {
        return (DocumentType)this.context.getDirectory(DocumentType.class, -1).get(typeId);
    }

    public int documentTypeUpdate(DocumentType type) throws Exception {
        try {
            this.context.getDirectory(DocumentType.class, -1).update((Id)type);
            return type.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int documentTypeDelete(int typeId) throws Exception {
        try {
            return this.context.getDirectory(DocumentType.class, -1).delete(typeId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<DocumentStatus> documentStatusList() throws Exception {
        return this.context.getDirectory(DocumentStatus.class, -1).list();
    }

    public DocumentStatus documentStatusGet(int statusId) throws Exception {
        return (DocumentStatus)this.context.getDirectory(DocumentStatus.class, -1).get(statusId);
    }

    public int documentStatusUpdate(DocumentStatus status) throws Exception {
        try {
            this.context.getDirectory(DocumentStatus.class, -1).update((Id)status);
            return status.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int documentStatusDelete(int statusId) throws Exception {
        try {
            return this.context.getDirectory(DocumentStatus.class, -1).delete(statusId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<DocumentStatusLogItem> getDocumentStatusLogList(int documentId) throws Exception {
        DocumentStatusDao documentStatusDao = new DocumentStatusDao(this.getConnection());
        List<DocumentStatusLogItem> result = documentStatusDao.getStatusHistory(documentId);
        documentStatusDao.close();
        return result;
    }

    public List<DocumentStatusLogItem> updateStatusLog(DocumentStatusLogItem item) throws Exception {
        DocumentStatusDao statusDao = new DocumentStatusDao(this.getConnection());
        item.setUserId(this.userId);
        statusDao.addStatusLog(item);
        List<DocumentStatusLogItem> result = statusDao.getStatusHistory(item.getDocumentId());
        statusDao.close();
        return result;
    }

    public Document generateDocument(int cid, int patternId, int journal, int type) throws Exception {
        Document result;
        DocumentPattern pattern = this.documentsPatternService.getPattern(patternId);
        if (pattern == null) {
            throw new BGIllegalArgumentException();
        }
        DocumentsPatternGenerator generator = new DocumentsPatternGenerator(this.getConnection(), pattern, cid, type, journal, this.userId);
        try {
            result = generator.generateDocument(null);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        EventProcessor.getInstance().publishAfterCommit((Event)new DocumentGeneratedEvent(-1, this.plugin.getPluginUID(), cid, this.userId, result));
        return result;
    }

    public List<String> checkNotFillParams(int cid, int patternId, int journal, int type) throws Exception {
        DocumentPattern pattern = this.documentsPatternService.getPattern(patternId);
        if (pattern == null) {
            throw new BGIllegalArgumentException();
        }
        return new DocumentsPatternGenerator(this.getConnection(), pattern, cid, type, journal, this.userId).getNotFillParameters();
    }

    public File getFileNetShare(int id, String title) throws Exception {
        FileStorage documentsFileStorage = this.getFileStorage();
        String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
        if (Utils.isBlankString((String)rootPath)) {
            return null;
        }
        return new File(documentsFileStorage.getFileName(id));
    }

    public void sendDocumentLinkFiles(List<String> emails, int documentId, List<Integer> fileIds, int leastTime) throws Exception {
        Document document = this.documentDao.getDocument(documentId);
        if (document == null) {
            throw new BGMessageException("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + documentId + "]");
        }
        StringBuilder link = new StringBuilder(String.valueOf(document.getId()));
        if (fileIds != null && !fileIds.isEmpty()) {
            for (int fileId : fileIds) {
                link.append(":").append(fileId);
            }
        }
        link.append("-").append(System.currentTimeMillis() / 1000L);
        link.append("-").append(leastTime);
        if (document.getFileSecret() == null) {
            document.setFileSecret(this.documentDao.updateDocumentSecret(documentId));
        }
        String sign = Utils.getDigest((String)(link.toString() + document.getFileSecret()), (String)"UTF-8", (String)"SHA256").toLowerCase();
        link.append("-").append(sign);
        MailMsg mailMsg = new MailMsg((Preferences)Setup.getSetup());
        String linkUrl = this.plugin.getSetup().get("documents.file.url", null);
        String text = linkUrl + "docs/" + link.toString();
        String subject = this.plugin.getSetup().get("documents.file.email.subject", "\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \"{document.title}\"").replace("{document.title}", document.getTitle());
        for (String email : emails) {
            try {
                mailMsg.sendMessage(new MailSendDocumentLinkFiles().setRecipients(email).setSubject(subject).addTextPart("text", text));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public void reinitDocumentSecret(int documentId) throws Exception {
        this.documentDao.updateDocumentSecret(documentId);
    }
}

