/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.FlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.RowSelector;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowAnalyzer;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.reports.Charts;

public class AnalyzedFlowDetailMaker
extends FlowDetailMaker {
    public int i = 0;

    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterable<IPHourlyDataLog> logs, StringBuilder messageBody, String subject) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(524288);
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.setLevel(setup.getInt("ipn.collector.detail.compression.level", -1));
        zos.putNextEntry(new ZipEntry("detail.csv"));
        PrintStream csvReport = new PrintStream((OutputStream)zos, false, "UTF-8");
        csvReport.append("\u0412\u0440\u0435\u043c\u044f;\u0421 \u0430\u0434\u0440\u0435\u0441\u0430;\u0421 \u043f\u043e\u0440\u0442\u0430;\u041d\u0430 \u0430\u0434\u0440\u0435\u0441;\u041d\u0430 \u043f\u043e\u0440\u0442;\u0411\u0430\u0439\u0442;\u0421 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430;\u041d\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        FlowAnalyzer analyzer = new FlowAnalyzer();
        long currentPeriod = -1L;
        long lastPeriod = -1L;
        long inputOctets = 0L;
        long outputOctets = 0L;
        TimeSeriesEx inputSeries = new TimeSeriesEx("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411)");
        TimeSeriesEx outputSeries = new TimeSeriesEx("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411)");
        Minute timePeriod = null;
        for (FlowArray f : IPDataLogUtils.newFlowDetailIterable(logs, (FlowSelector)selector, (int)10000)) {
            int size = f.size;
            for (int i = 0; i < size; ++i) {
                IPDataLogUtils.FlowDetail detail = ((IPDataLogUtils.FlowDetail[])f.array)[i];
                long period = detail.milliseconds / 60000L * 1000L * 60L;
                if (period != currentPeriod) {
                    if (currentPeriod != -1L) {
                        if (lastPeriod != -1L) {
                            for (long div = lastPeriod + 60000L; div < currentPeriod; div += 60000L) {
                                timePeriod = new Minute(new Date(div));
                                inputSeries.addOrPlus((RegularTimePeriod)timePeriod, 0.0);
                                outputSeries.addOrPlus((RegularTimePeriod)timePeriod, 0.0);
                            }
                        }
                        timePeriod = new Minute(new Date(currentPeriod));
                        inputSeries.addOrPlus((RegularTimePeriod)timePeriod, (double)inputOctets / 1024.0);
                        outputSeries.addOrPlus((RegularTimePeriod)timePeriod, (double)outputOctets / 1024.0);
                        inputOctets = 0L;
                        outputOctets = 0L;
                    }
                    lastPeriod = currentPeriod;
                    currentPeriod = period;
                }
                if (detail.direction == 1) {
                    inputOctets += detail.octets;
                    analyzer.input(detail.srcAddress, (Data)detail);
                } else {
                    outputOctets += detail.octets;
                    analyzer.output(detail.dstAddress, (Data)detail);
                }
                this.printToCsv(csvReport, (Data)detail, dateFormat);
            }
        }
        if (currentPeriod != -1L) {
            timePeriod = new Minute(new Date(currentPeriod));
            inputSeries.addOrPlus((RegularTimePeriod)timePeriod, (double)inputOctets / 1024.0);
            outputSeries.addOrPlus((RegularTimePeriod)timePeriod, (double)outputOctets / 1024.0);
        }
        csvReport.flush();
        zos.closeEntry();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries((TimeSeries)inputSeries);
        dataset.addSeries((TimeSeries)outputSeries);
        zos.putNextEntry(new ZipEntry("detail.png"));
        ChartUtils.writeChartAsPNG((OutputStream)zos, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)new XYStepRenderer(), (XYDataset)dataset), (int)832, (int)275, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
        inputSeries.clear();
        outputSeries.clear();
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("detail.html"));
        this.writeHTML(zos, analyzer, task, (ParameterMap)setup);
        analyzer.clear();
        zos.closeEntry();
        zos.flush();
        zos.close();
        zos = null;
        final byte[] data = bos.toByteArray();
        bos = null;
        String fileName = "detail.zip";
        MimeMultipart m = new MimeMultipart();
        MimeBodyPart attach = new MimeBodyPart();
        m.addBodyPart((BodyPart)attach);
        DataSource ds = new DataSource(){

            public String getContentType() {
                return "application/zip";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(data);
            }

            public String getName() {
                return "detail.zip";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
        attach.setDataHandler(new DataHandler(ds));
        attach.setFileName("detail.zip");
        this.sendDetailMail(setup, task, subject, messageBody, attach);
    }

    protected void writeHTML(OutputStream out, FlowAnalyzer analyzer, DetailCreateTask task, ParameterMap params) {
        try {
            String title = this.getMessageBody(task).toString();
            String XHTML_NS = "http://www.w3.org/1999/xhtml";
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter(out, "UTF-8");
            w.writeStartDocument("UTF-8", "1.0");
            w.writeCharacters("\n");
            w.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            w.writeStartElement("html");
            w.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            w.writeStartElement("head");
            this.writeHTMLHead(w, title);
            this.writeHTMLStyle(w);
            w.writeEndElement();
            w.writeCharacters("\n");
            w.writeStartElement("body");
            w.writeStartElement("div");
            w.writeAttribute("class", "body");
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "title");
            w.writeCharacters(title);
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "plot_title");
            w.writeCharacters("\u0422\u0440\u0430\u0444\u0438\u043a \u0432 \u043c\u0438\u043d\u0443\u0442\u0443 (\u041a\u0411)");
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "plot");
            w.writeStartElement("img");
            w.writeAttribute("src", "detail.png");
            w.writeAttribute("alt", "\u0422\u0440\u0430\u0444\u0438\u043a \u0432 \u043c\u0438\u043d\u0443\u0442\u0443 (\u041a\u0411)");
            w.writeEndElement();
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "data_title");
            w.writeCharacters("\u0410\u043d\u0430\u043b\u0438\u0437");
            w.writeEndElement();
            this.writeInfo(w, analyzer, task, params);
            this.writeTable(w, analyzer, task, params);
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeInfo(XMLStreamWriter w, FlowAnalyzer analyzer, DetailCreateTask task, ParameterMap params) throws Exception {
        w.writeStartElement("div");
        w.writeAttribute("class", "info");
        w.writeCharacters("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u0444\u0438\u043a\u0430 \u043f\u043e ip \u0430\u0434\u0440\u0435\u0441\u0430\u043c, \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430\u043c \u0438 \u043f\u043e\u0440\u0442\u0430\u043c, \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.");
        w.writeEmptyElement("br");
        w.writeCharacters("HTTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 www \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
        w.writeEmptyElement("br");
        w.writeCharacters("SMTP - \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e\u0447\u0442\u044b");
        w.writeEmptyElement("br");
        w.writeCharacters("POP3/IMAP - \u043f\u0440\u0438\u0435\u043c \u043f\u043e\u0447\u0442\u044b");
        w.writeEmptyElement("br");
        w.writeCharacters("FTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 ftp \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
        w.writeEmptyElement("br");
        w.writeCharacters("UDP named - \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c\u044b\u0439 \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0439 \u0438\u043c\u0435\u043d \u0445\u043e\u0441\u0442\u043e\u0432 \u0432 ip \u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e, \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0435\u043d \u043f\u0440\u0438 \u0437\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0432\u0438\u0440\u0443\u0441\u0430\u043c\u0438 \u043c\u0430\u0448\u0438\u043d \u0432 \u043b\u043e\u043aa\u043b\u044c\u043d\u043e\u0439 \u0441\u0435\u0442\u0438");
        w.writeEmptyElement("br");
        w.writeCharacters("\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043e\u0442\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u043c \u043f\u043e \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u044e \u043f\u043e\u0440\u044f\u0434\u043a\u0435");
        w.writeEndElement();
    }

    protected void writeTable(XMLStreamWriter w, FlowAnalyzer analyzer, DetailCreateTask task, ParameterMap params) throws Exception {
        w.writeStartElement("table");
        w.writeAttribute("width", "100%");
        w.writeAttribute("cellpadding", "0");
        w.writeAttribute("cellspacing", "0");
        w.writeAttribute("border", "0");
        w.writeAttribute("class", "data");
        w.writeStartElement("thead");
        w.writeStartElement("tr");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "IP", "2", "1", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "\u0412\u0441\u0435\u0433\u043e", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP/UDP/ICMP/\u0414\u0440\u0443\u0433\u043e\u0435", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP: HTTP", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP: SMTP/POP3/IMAP/FTP", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "UDP named", "1", "2", "line");
        w.writeEndElement();
        w.writeStartElement("tr");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        w.writeEndElement();
        w.writeEndElement();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("########0.00", dfs);
        double divisor = 1024.0;
        int count = 0;
        int maxResolve = params.getInt("ipn.collector.detail.hostresolve", 5);
        w.writeStartElement("tbody");
        for (FlowAnalyzer.FlowAnalizerEntry f : analyzer.get()) {
            w.writeStartElement("tr");
            if (count++ < maxResolve) {
                String host = InetAddress.getByAddress(f.ip.address).getHostName();
                String ip = f.ip.toString();
                if (!ip.equals(host)) {
                    w.writeStartElement("td");
                    w.writeAttribute("rowspan", "4");
                    w.writeAttribute("class", "line");
                    w.writeCharacters(ip);
                    w.writeEmptyElement("br");
                    w.writeCharacters(host);
                    w.writeEndElement();
                } else {
                    AnalyzedFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
                }
            } else {
                AnalyzedFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
            }
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctets() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctets() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpHttp() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpHttp() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpSmtp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpSmtp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsUdpNamed() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsUdpNamed() / 1024.0), "4", "line");
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsUdp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsUdp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpPop3() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpPop3() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsIcmp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsIcmp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpImap() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpImap() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)(f.input.getOctets() - f.input.getOctetsIcmp() - f.input.getOctetsTcp() - f.input.getOctetsUdp()) / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)(f.output.getOctets() - f.output.getOctetsIcmp() - f.output.getOctetsTcp() - f.output.getOctetsUdp()) / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpFtp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpFtp() / 1024.0));
            w.writeEndElement();
        }
        w.writeEndElement();
        w.writeEndElement();
    }

    protected void writeHTMLHead(XMLStreamWriter w, String title) throws XMLStreamException {
        w.writeStartElement("title");
        w.writeCharacters(title);
        w.writeEndElement();
        w.writeStartElement("meta");
        w.writeAttribute("http-equiv", "Content-Type");
        w.writeAttribute("content", "text/html; charset=UTF-8");
        w.writeEndElement();
    }

    protected void writeHTMLStyle(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement("style");
        w.writeCharacters("tbody td.line {border-top-style: solid; border-top-width: 1px; border-top-color: #000000;}\n");
        w.writeCharacters("table.data td {font-family: sansserif; font-size: 8.0px;}\n");
        w.writeCharacters("table.data thead td {font-weight: bold; padding: 1px;}\n");
        w.writeCharacters("div.plot {text-align: center;}\n");
        w.writeCharacters("div.body {margin:0 auto; width: 842px;}\n");
        w.writeCharacters("div.title {text-align: center; font-family: sansserif; font-size: 12.0px; font-weight: bold; margin-top: 20px;}\n");
        w.writeCharacters("div#plot_title, div#data_title {font-size: 11.0px}\n");
        w.writeCharacters("div.info {font-size: 8.0px}\n");
        w.writeCharacters("table.data {margin-top: 10px; border-bottom: solid 1px;}\n");
        w.writeEndElement();
    }

    private static final void writeTD(XMLStreamWriter w, String data) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String colspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("colspan", colspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    class TimeSeriesEx
    extends TimeSeries {
        public TimeSeriesEx(String name) {
            super((Comparable)((Object)name));
        }

        public void addOrPlus(RegularTimePeriod period, double value) {
            TimeSeriesDataItem item = new TimeSeriesDataItem(period, value);
            if (!item.getPeriod().getClass().equals(this.timePeriodClass)) {
                StringBuffer b = new StringBuffer();
                b.append("You are trying to add data where the time period class ");
                b.append("is ");
                b.append(item.getPeriod().getClass().getName());
                b.append(", but the TimeSeries is expecting an instance of ");
                b.append(this.timePeriodClass.getName());
                b.append(".");
                throw new SeriesException(b.toString());
            }
            int count = this.getItemCount();
            if (count == 0) {
                this.data.add(item);
                this.removeAgedItems(false);
                this.fireSeriesChanged();
            } else {
                RegularTimePeriod last = this.getTimePeriod(this.getItemCount() - 1);
                if (item.getPeriod().compareTo((Object)last) > 0) {
                    this.data.add(item);
                    this.removeAgedItems(false);
                    this.fireSeriesChanged();
                } else {
                    int index = Collections.binarySearch(this.data, item);
                    if (index < 0) {
                        this.data.add(-index - 1, item);
                        this.removeAgedItems(false);
                        this.fireSeriesChanged();
                    } else {
                        TimeSeriesDataItem existing = (TimeSeriesDataItem)this.data.get(index);
                        existing.setValue((Number)(existing.getValue().doubleValue() + value));
                        this.removeAgedItems(false);
                        this.fireSeriesChanged();
                    }
                }
            }
        }
    }
}

