/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerPropertyParam;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class CustomerPropertyDialog {
    private BGOptionPane optionPane;
    private ClientContext clientContext;
    private BGUComboBox<IdTitle> logins;
    private BGUComboBox<IdTitle> accessMode;
    private BGTextField password;
    private BGButton autoPassword;
    private JCheckBox sendPassword;
    private ParamTableModel paramTableModel = new ParamTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.paramTableModel));
    private JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");

    public CustomerPropertyDialog(ClientContext clientContext) {
        this.clientContext = clientContext;
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.optionPane = new BGOptionPane((Object)this.getTabbedPanel(), "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", new JButton[]{this.saveButton, cancelButton});
        this.saveButton.addActionListener(e -> this.getDialog().setVisible(false));
        cancelButton.addActionListener(e -> this.getDialog().setVisible(false));
        this.getDialog().setVisible(true);
        this.getDialog().dispose();
    }

    private JTabbedPane getTabbedPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("\u0414\u043e\u0441\u0442\u0443\u043f \u0432 \u041b\u041a", this.getWebLogonPanel());
        tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.geParamPanel());
        tabbedPane.addChangeListener(e -> {
            if (tabbedPane.getSelectedIndex() == 1) {
                try {
                    this.paramTableModel.setData(((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerPropertyParams(this.clientContext.getCustomerId()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        return tabbedPane;
    }

    private JPanel getWebLogonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getLoginPasswordPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.getContractAccessModePanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel geParamPanel() {
        this.table.setRowHeight(20);
        this.table.setFont(this.table.getFont().deriveFont(1.2f * this.table.getFont().getSize2D()));
        this.table.setSelectionMode(0);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.addPropertyChangeListener(e -> {
            if ("tableCellEditor".equals(e.getPropertyName()) && e.getNewValue() == null) {
                try {
                    JSONObject properties;
                    CustomerPropertyParam param = (CustomerPropertyParam)this.paramTableModel.getSelectedRow();
                    ((CustomerService)this.clientContext.getWebService(CustomerService.class, 0)).customerParameterUpdate(this.clientContext.getCustomerId(), "/customer/properties/" + param.getKey(), param.getValue());
                    JSONObject customer = this.clientContext.getCustomer().optJSONObject("customer");
                    if (customer == null) {
                        customer = new JSONObject();
                        this.clientContext.getCustomer().put("customer", (Object)customer);
                    }
                    if ((properties = customer.optJSONObject("properties")) == null) {
                        properties = new JSONObject();
                        customer.put("properties", (Object)properties);
                    }
                    properties.put(param.getKey(), (Object)param.getValue());
                    System.out.println(this.clientContext.getCustomer().toString(4));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.table, (int)800, (int)400), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getLoginPasswordPanel() {
        this.logins = new BGUComboBox();
        ArrayList<IdTitle> contacts = new ArrayList<IdTitle>();
        Object customerContact = this.clientContext.getCustomer().optQuery("/customer/contact");
        if (customerContact instanceof JSONObject) {
            JSONObject customerContactJson = (JSONObject)customerContact;
            for (String key : customerContactJson.keySet()) {
                if (!key.startsWith("email_")) continue;
                contacts.add(new IdTitle(0, customerContactJson.optString(key)));
            }
        }
        this.logins.setData(contacts);
        this.password = new BGTextField(10);
        this.password.setHorizontalAlignment(0);
        this.password.setFont(this.password.getFont().deriveFont(this.password.getFont().getSize2D() * 1.3f).deriveFont(1));
        this.autoPassword = new BGButton("\u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
        this.autoPassword.addActionListener(e -> this.password.setText(String.valueOf((long)(Math.random() * 1.0E10))));
        this.sendPassword = new JCheckBox("\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0430 e-mail");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d (e-mail):"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.logins, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.password, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.autoPassword, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.sendPassword, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractAccessModePanel() {
        this.accessMode = new BGUComboBox();
        this.accessMode.setData(Arrays.asList(new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043a \u0432\u0441\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u0430"), new IdTitle(2, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043a \u0432\u0441\u0435\u043c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c"), new IdTitle(3, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c \u043d\u0438\u0436\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c"), new IdTitle(4, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c \u043d\u0438\u0436\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c")));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)this.accessMode, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)new BGControlPanelListSelect(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private JDialog getDialog() {
        return this.optionPane.getDialog();
    }

    public class ParamTableModel
    extends BGTableModel<CustomerPropertyParam> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 200, 300, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 0, -1, -1, "value", false, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

