/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGListToggleButton
extends JPanel {
    List<ButtonListItemList> items = new ArrayList<ButtonListItemList>();
    JToggleButton mainButton = new JToggleButton(){
        {
            this.setFont(new Font("Dialog", 1, 14));
        }
    };
    JButton switchButton = new JButton(){
        {
            this.setIcon(ClientUtils.getIcon("item_down.png"));
            this.setMargin(new Insets(0, 2, 0, 2));
            this.addActionListener(e -> BGListToggleButton.this.setPopupVisible(true));
        }
    };
    Popup popup;

    public BGListToggleButton() {
        Popup cp = null;
        try {
            cp = new Popup();
        }
        catch (Throwable ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.popup = cp;
        UIManager.addPropertyChangeListener(e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                SwingUtilities.updateComponentTreeUI(this.popup);
            }
        });
        this.popup.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("changeMode")) {
                for (ButtonListItemList item : this.items) {
                    if (!e.getNewValue().equals(item.mode)) continue;
                    this.mainButton.setText(item.text);
                    this.mainButton.setActionCommand(item.mode);
                    this.mainButton.setSelected(true);
                    this.mainButton.doClick();
                    break;
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.mainButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.switchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setPopupVisible(boolean visible) {
        this.popup.show(this.switchButton, 0, this.switchButton.getHeight() + 1);
    }

    public void addItem(String text, String mode) {
        this.items.add(new ButtonListItemList(text, mode));
        this.popup.reinit(this.items);
        if (this.items.size() == 1) {
            this.mainButton.setText(text);
            this.mainButton.setActionCommand(mode);
        }
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        buttonGroup.add(this.mainButton);
    }

    public void setSelected(String mode) {
        this.mainButton.setSelected(false);
        for (ButtonListItemList item : this.items) {
            if (!mode.equals(item.mode)) continue;
            this.mainButton.setText(item.text);
            this.mainButton.setActionCommand(item.mode);
            this.mainButton.setSelected(true);
            break;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.mainButton.addActionListener(actionListener);
    }

    private class Popup
    extends JPopupMenu {
        String oldMode = "";
        ActionListener actionListener = event -> {
            this.setVisible(false);
            this.selectMode(event.getActionCommand());
        };

        public void reinit(List<ButtonListItemList> items) {
            this.removeAll();
            this.setLayout(new GridLayout(items.size(), 1));
            for (int i = 0; i < items.size(); ++i) {
                ButtonListItemList itemList = items.get(i);
                JButton button = new JButton(itemList.text);
                button.setActionCommand(itemList.mode);
                button.addActionListener(this.actionListener);
                this.add(button);
            }
        }

        public void selectMode(String newMode) {
            if (!this.oldMode.equals(newMode)) {
                this.firePropertyChange("changeMode", this.oldMode, newMode);
                this.oldMode = newMode;
            }
        }
    }

    class ButtonListItemList {
        final String text;
        final String mode;

        ButtonListItemList(String text, String mode) {
            this.text = text;
            this.mode = mode;
        }
    }
}

