/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class Editor
extends Canvas {
    private Font font = new Font("", 0, 10);
    private FontMetrics FM = null;
    private int startValue = 1;
    private int stepValue = 1;
    private boolean[] selected = null;
    private int count = 1;

    public Editor() {
        this.setData(1, 1, 1, 0L);
        final AreaMaker am = new AreaMaker();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.isShiftDown()) {
                    am.makeArea(e);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                am.makeArea(e);
            }
        });
    }

    public void setData(int startValue, int endValue, int stepValue, long value) {
        this.startValue = startValue;
        this.stepValue = stepValue;
        this.selected = new boolean[(endValue - startValue) / stepValue + 1];
        this.count = (endValue - startValue) / stepValue + 1;
        for (int i = 0; i < this.selected.length; ++i) {
            if ((value & (long)Math.pow(2.0, i)) <= 0L) continue;
            this.selected[i] = true;
        }
        this.repaint();
    }

    public long getData() {
        long value = 0L;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            value |= (long)Math.pow(2.0, i);
        }
        return value;
    }

    @Override
    public void paint(Graphics g) {
        if (this.count == 1) {
            return;
        }
        g.setFont(this.font);
        this.FM = g.getFontMetrics(this.font);
        int w = this.getSize().width;
        int h = this.getSize().height;
        int cw = w / this.count;
        int offsetX = (w - this.count * cw) / 2;
        int value = this.startValue;
        for (int i = 0; i < this.count; ++i) {
            String title = "" + value;
            value += this.stepValue;
            if (this.stepValue > 1) {
                title = title + " - " + (value - 1);
            }
            g.setColor(Color.black);
            g.drawString(title, offsetX + 1 + i * cw + (cw - this.FM.stringWidth(title)) / 2, h / 2 - 1);
            g.setColor(this.selected[i] ? Color.blue : Color.white);
            g.fillRect(offsetX + i * cw + 1, h / 2 + 1, cw - 2, h / 2 - 2);
        }
    }

    class AreaMaker {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int cw = 0;
        int offsetX = 0;

        AreaMaker() {
        }

        public void makeArea(MouseEvent e) {
            if (!this.inArea(e)) {
                return;
            }
            int c = (this.x - this.offsetX) / this.cw;
            Editor.this.selected[c] = !Editor.this.selected[c];
            Editor.this.repaint();
        }

        private boolean inArea(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
            this.w = Editor.this.getSize().width;
            this.h = Editor.this.getSize().height;
            this.cw = this.w / Editor.this.count;
            this.offsetX = (this.w - Editor.this.count * this.cw) / 2;
            if (this.y < this.h / 2 + 1 || this.y > this.h - 1) {
                return false;
            }
            return this.x >= this.offsetX && this.x <= this.w - this.offsetX;
        }
    }
}

