/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.megafon.client.MegafonEditorDialog;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class MegafonProductPanel
extends BGUPanel {
    private MegafonService megafonService;
    private BGUTable table;
    private MegafonProductTableModel productTableModel;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.productTableModel = new MegafonProductTableModel();
        this.table = new BGUTable((TableModel)((Object)this.productTableModel));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ProductEditorDialog(null).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MegafonProduct selected = (MegafonProduct)this.productTableModel.getSelectedRow();
            if (selected != null) {
                new ProductEditorDialog(selected).open();
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MegafonProduct selected = (MegafonProduct)this.productTableModel.getSelectedRow();
            if (selected != null && ClientUtils.confirmDelete((Object)selected.getTitle(), (boolean)true)) {
                this.getMegafonService().deleteProduct(selected.getId());
                this.performAction("refresh");
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.productTableModel.setData(this.getMegafonService().getProductList()));
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private final class MegafonProductTableModel
    extends BGTableModel<MegafonProduct> {
        public MegafonProductTableModel() {
            super("megafonProductTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false);
        }
    }

    private final class ProductEditorDialog
    extends MegafonEditorDialog<MegafonProduct> {
        private final BGUComboBox<MegafonOptionKit> optionKit;
        private final JTextField tariffLabelId;
        private final JTextField price;

        public ProductEditorDialog(MegafonProduct data) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", data);
            this.optionKit = new BGUComboBox();
            this.tariffLabelId = new JTextField();
            this.price = new JTextField();
            try {
                ArrayList<MegafonOptionKit> optionKits = new ArrayList<MegafonOptionKit>();
                optionKits.add(new MegafonOptionKit("----------"));
                optionKits.addAll(MegafonProductPanel.this.getMegafonService().getOptionKitList());
                this.optionKit.setData(optionKits);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        @Override
        public void doDialogPanel() {
            super.doDialogPanel();
            this.panel.add((Component)new JLabel("ID \u043c\u0435\u0442\u043a\u0438 \u0442\u0430\u0440\u0438\u0444\u0430"), this.constraints);
            this.panel.add((Component)this.tariffLabelId, this.constraints);
            this.panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u0443\u0433"), this.constraints);
            this.panel.add((Component)this.optionKit, this.constraints);
            this.panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c"), this.constraints);
            this.panel.add((Component)this.price, this.constraints);
            if (this.data != null) {
                this.title.setText(((MegafonProduct)this.data).getTitle());
                this.productOfferingId.setText(((MegafonProduct)this.data).getProductOfferingId());
                this.npayServiceId.setText(String.valueOf(((MegafonProduct)this.data).getNpayServiceId()));
                int optionKitId = ((MegafonProduct)this.data).getOptionKitId();
                MegafonOptionKit kit = this.optionKit.getData().stream().filter(k -> k.getId() == optionKitId).findFirst().orElse(null);
                if (kit != null) {
                    this.optionKit.setSelectedItem((Object)kit);
                } else {
                    this.optionKit.setSelectedIndex(0);
                }
                this.tariffLabelId.setText(String.valueOf(((MegafonProduct)this.data).getTariffLabelId()));
                this.price.setText(String.valueOf(((MegafonProduct)this.data).getPrice()));
            }
        }

        public boolean doApply() throws Exception {
            if (this.data == null) {
                this.data = new MegafonProduct();
            }
            int serviceId = Utils.parseInt((String)this.npayServiceId.getText(), (int)0);
            if (Utils.isBlankString((String)this.title.getText()) || Utils.isBlankString((String)this.productOfferingId.getText()) || serviceId <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b!");
                return false;
            }
            if (Utils.isBlankString((String)this.title.getText())) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            int priceValue = Utils.parseInt((String)this.price.getText());
            if (priceValue <= 0) {
                BGToolTip.showErrorMessage((JComponent)this.price, (String)"\u0417\u0430\u0434\u0430\u0439\u0442\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c!");
                return false;
            }
            ((MegafonProduct)this.data).setTitle(this.title.getText());
            ((MegafonProduct)this.data).setProductOfferingId(this.productOfferingId.getText());
            ((MegafonProduct)this.data).setNpayServiceId(serviceId);
            ((MegafonProduct)this.data).setTariffLabelId(Utils.parseInt((String)this.tariffLabelId.getText(), (int)0));
            ((MegafonProduct)this.data).setPrice(priceValue);
            if (this.optionKit.getSelectedItem() != null && ((MegafonOptionKit)this.optionKit.getSelectedItem()).getId() > 0) {
                ((MegafonProduct)this.data).setOptionKitId(((MegafonOptionKit)this.optionKit.getSelectedItem()).getId());
            }
            MegafonProductPanel.this.getMegafonService().updateProduct((MegafonProduct)this.data);
            MegafonProductPanel.this.performAction("refresh");
            return true;
        }
    }
}

