/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.quantity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class InetModuleQuantity
extends ModuleQuantity {
    @Override
    public List<ModuleQuantity.ModuleQuantityResult> getPeriodQuantity(Connection con, int contractId, Calendar from, Calendar to) {
        return this.getPeriodsFromTable(con, "inet_serv_" + this.getModuleId(), contractId, from, to, null);
    }

    @Override
    protected List<ModuleQuantity.ModuleQuantityResult> getPeriodsFromTable(Connection con, String tableName, int contractIdid, Calendar from, Calendar to, String filter) {
        HashMap<Integer, Period> map = new HashMap<Integer, Period>();
        ArrayList<ModuleQuantity.ModuleQuantityResult> result = new ArrayList<ModuleQuantity.ModuleQuantityResult>();
        HashSet<Integer> parantServIdSet = new HashSet<Integer>();
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            String query = "SELECT id, parentId, dateFrom, dateTo FROM " + tableName + " WHERE contractId=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) ";
            if (Utils.notBlankString((String)filter)) {
                query = query + filter;
            }
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, contractIdid);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int parentId = rs.getInt("parentId");
                    map.put(rs.getInt("id"), new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo")));
                    if (parentId <= 0) continue;
                    parantServIdSet.add(parentId);
                }
                rs.close();
                ps.close();
                for (Map.Entry entry : map.entrySet()) {
                    if (parantServIdSet.contains(entry.getKey())) continue;
                    result.add(new ModuleQuantity.ModuleQuantityResult((Period)entry.getValue(), 1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

