/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.server.action;

import bitel.billing.server.ActionBase;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerManager;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionGetCurrentTaskList
extends ActionBase {
    public void doAction() throws Exception {
        String users = this.getParameter("users", "my");
        String stat = this.getParameter("status", "all");
        Page page = this.getPage();
        int uid = 0;
        int status = 0;
        if ("my".equals(users)) {
            uid = this.userId;
        }
        if ("current".equals(stat)) {
            status = 1;
        } else if ("outofdate".equals(stat)) {
            status = 2;
        }
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        new OrganizerManager(this.con).searchTodoRecords((SearchResult<OrganizerRecord>)searchResult, uid, status);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (OrganizerRecord rec : searchResult.getList()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(rec.getId()));
            row.setAttribute("title", rec.getTitle());
            row.setAttribute("comment", rec.getComment());
            row.setAttribute("uid", String.valueOf(rec.getUid()));
            row.setAttribute("user_name", rec.getUserName());
            String whoCompletes = "";
            if (rec.getTodoUid() <= 0) {
                whoCompletes = rec.getTodoGroup();
                row.setAttribute("todo_gid", String.valueOf(rec.getTodoGid()));
            } else {
                whoCompletes = rec.getTodoUserName();
                row.setAttribute("todo_uid", String.valueOf(rec.getTodoUid()));
            }
            row.setAttribute("who_complets", whoCompletes);
            row.setAttribute("cid", String.valueOf(rec.getCid()));
            row.setAttribute("contract", rec.getContractTitle());
            row.setAttribute("created", TimeUtils.formatDate((Date)rec.getCreationDate()));
            row.setAttribute("period", TimeUtils.formatDate((Date)rec.getPeriod().getDateFrom()) + " -- " + TimeUtils.formatDate((Date)rec.getPeriod().getDateTo()));
            row.setAttribute("status", rec.getStatus());
        }
        this.setPageAttribute(table, page);
    }
}

