/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server;

import bitel.billing.server.ModuleBase;
import java.time.LocalDate;
import java.util.Date;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.service.RunTelService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.runtel.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractCloseEvent) {
            ContractCloseEvent contractCloseEvent = (ContractCloseEvent)event;
            if (contractCloseEvent.isCheck()) return;
            RunTelService runTelService = (RunTelService)serverContext.getService(RunTelService.class, moduleId);
            LocalDate dateTo = TimeUtils.convertDateToLocalDate((Date)contractCloseEvent.getDate());
            SearchResult searchResult = runTelService.searchContractRunTelTariff(contractCloseEvent.getContractId(), new PeriodWithTime(dateTo.atStartOfDay(), null));
            for (RunTelContractTariff runTelContractTariff : searchResult.getList()) {
                PeriodWithTime period = runTelContractTariff.getPeriod();
                if (period == null || period.getDateTo() != null && !period.getDateTo().after(contractCloseEvent.getDate())) continue;
                runTelService.updateContractTariffDateTo(runTelContractTariff.getId(), dateTo.atStartOfDay().plusDays(1L).minusSeconds(1L));
            }
            return;
        } else {
            if (event instanceof ContractWrapEvent) {
                ContractWrapEvent contractWrapEvent = (ContractWrapEvent)event;
                if (contractWrapEvent.isCheck()) return;
            }
            if (event instanceof ContractCreateEvent) {
                Document dataDoc;
                ContractCreateEvent ccEvent = (ContractCreateEvent)event;
                if (!ccEvent.isCheck() && (dataDoc = ccEvent.getPattern().getData()) == null) return;
            }
            if (!(event instanceof ContractDeleteEvent)) return;
        }
    }
}

