/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.idealer;

import bitel.billing.server.ActionConType;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBaseIDealer;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.bgbilling.modules.card.server.bean.DealerManager;
import ru.bitel.bgbilling.modules.card.server.idealer.Conf;
import ru.bitel.bgbilling.modules.card.server.idealer.findbean.FindContractUtils;
import ru.bitel.common.util.AverageCounter;

@ActionConType(value=0)
public class ActionContractFind
extends ActionBaseIDealer {
    public static final ConcurrentMap<Integer, RequestCounter> requestCounterMap = new ConcurrentHashMap<Integer, RequestCounter>();
    public static final ConcurrentMap<Integer, RequestCounter> findCounterMap = new ConcurrentHashMap<Integer, RequestCounter>();

    public static void incDealerRequest(DealerDao dealerDao, int dealerId) {
        ActionContractFind.incDealer(requestCounterMap, dealerId, count -> {
            try {
                dealerDao.incDealerRequest(dealerId, count);
            }
            catch (Exception ex) {
                BGLogger.error((Throwable)ex);
            }
        });
    }

    public static void incDealerFind(DealerManager dealerManager, int dealerId) {
        ActionContractFind.incDealer(findCounterMap, dealerId, count -> dealerManager.incDealerFinded(dealerId, count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incDealer(ConcurrentMap<Integer, RequestCounter> findCounterMap, int dealerId, IntConsumer consumer) {
        long average;
        long lastRequest;
        RequestCounter requestCounter;
        long millis = System.currentTimeMillis();
        RequestCounter requestCounter2 = requestCounter = findCounterMap.computeIfAbsent(dealerId, k -> new RequestCounter());
        synchronized (requestCounter2) {
            lastRequest = requestCounter.lastRequest;
            if (lastRequest + 10000L > millis) {
                requestCounter.average = average = requestCounter.averageCounter.getSum(millis, 30);
            } else {
                average = requestCounter.average;
            }
        }
        requestCounter.averageCounter.add(millis, 1L);
        requestCounter.lastRequest = millis;
        if (average < 20L || lastRequest + 90000L < millis) {
            int current = requestCounter.counter.get();
            consumer.accept(current + 1);
            if (current != 0) {
                requestCounter.counter.addAndGet(-current);
            }
            return;
        }
        int max = average > 1000L ? 1000 : (average > 500L ? 500 : (average > 300L ? 300 : (average > 200L ? 200 : (average > 100L ? 100 : 50))));
        int current = requestCounter.counter.addAndGet(1);
        if (current >= max) {
            RequestCounter requestCounter3 = requestCounter;
            synchronized (requestCounter3) {
                current = requestCounter.counter.get();
                if (current >= max) {
                    consumer.accept(current);
                    requestCounter.counter.addAndGet(-current);
                }
            }
        }
    }

    public void doAction() throws Exception {
        if (this.mid < 0 || this.dealer == null) {
            this.setErrorStatus("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0438/\u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", "3");
            return;
        }
        try {
            ActionContractFind.incDealerRequest(new DealerDao(this.con, this.mid), this.dealer.getId());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        Conf conf = (Conf)this.setup.getConfig(this.mid, Conf.class);
        List<Contract> contractList = FindContractUtils.findContract(this.conSlave, conf, (this.dealer.getParams() & 0xFFFFFFF) > 0 ? (long)this.dealer.getParams() & 0xFFFFL : this.dealer.getFindmodes(), (this.dealer.getParams() & 0xFFFFFFF) > 0 ? ((long)this.dealer.getParams() & 0x3FFF0000L) >> 16 : this.dealer.getAllowcontracts(), this.dealer.getAllowcontractsMode(), this.request, false);
        if (contractList.isEmpty()) {
            this.setErrorStatus("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "8");
        } else {
            DealerManager manager = new DealerManager(this.con, this.mid);
            if (contractList.size() == 1) {
                this.appendContract(manager, contractList.get(0));
            } else {
                this.setErrorStatus("\u0423\u0442\u043e\u0447\u043d\u0438\u0442\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \u043f\u043e\u0438\u0441\u043a\u0430", "9");
                if (this.moduleSetup.getInt("dealer.findcontract.fewresults", 0) > 0) {
                    for (Contract contract : contractList) {
                        this.appendContract(manager, contract);
                    }
                }
            }
        }
    }

    private boolean appendContract(DealerManager manager, Contract contract) throws Exception {
        if (contract != null) {
            try {
                ActionContractFind.incDealerFind(manager, this.dealer.getId());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            this.buildContractInfo(contract);
        }
        return contract != null;
    }

    static class RequestCounter {
        final AverageCounter averageCounter = new AverageCounter(60L, TimeUnit.SECONDS);
        final AtomicInteger counter = new AtomicInteger();
        volatile long lastRequest = 0L;
        volatile long average = 0L;

        RequestCounter() {
        }
    }
}

