/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public class DiscountCardTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private static final int LESS = 1;
    private static final int LESS_OR_EQ = 2;
    private static final int EQ = 3;
    private static final int MORE_OR_EQ = 4;
    private static final int MORE = 5;
    private int compare;
    private int cardCount;
    private BigDecimal discount;

    public DiscountCardTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.discount = parameterMap.getBigDecimal("discount_card", BigDecimal.ZERO);
        this.cardCount = parameterMap.getInt("card_count", 1);
        String compare = parameterMap.get("compare");
        if (compare.equals("<")) {
            this.compare = 1;
        } else if (compare.equals("<=")) {
            this.compare = 2;
        } else if (compare.equals("=")) {
            this.compare = 3;
        } else if (compare.equals(">=")) {
            this.compare = 4;
        } else if (compare.equals(">")) {
            this.compare = 5;
        }
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        int cardCount = tariffRequest.getCardCount();
        if (cardCount >= 0) {
            boolean check = false;
            switch (this.compare) {
                case 1: {
                    check = cardCount < this.cardCount;
                    break;
                }
                case 2: {
                    check = cardCount <= this.cardCount;
                    break;
                }
                case 3: {
                    check = cardCount == this.cardCount;
                    break;
                }
                case 4: {
                    check = cardCount >= this.cardCount;
                    break;
                }
                case 5: {
                    boolean bl = check = cardCount > this.cardCount;
                }
            }
            if (check) {
                tariffRequest.setDiscountCard(this.discount);
            }
        }
        return 1;
    }
}

