/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.client.RosterTree;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNode;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeGroup;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.common.IRosterItem;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;

public class RosterTreeNodeEntry
extends RosterTreeNode
implements Comparable<RosterTreeNodeEntry> {
    private String jid;
    private int priority;
    private IMConstants.STATUS status;
    private String statusmessage;
    private String subscr;
    private String name;
    boolean hasNewMessage = false;

    public RosterTreeNodeEntry(RosterTree tree) {
        super(tree);
    }

    @Override
    public String getToolTipText() {
        StringBuilder text = new StringBuilder(128);
        text.append("<html>");
        if (this.name != null) {
            text.append(this.name).append("<br>");
        }
        text.append("[").append(this.jid).append("]");
        if (this.subscr != null) {
            text.append("<br>Subscription: ").append(this.subscr);
        }
        if (this.status != null) {
            text.append("<br>").append(this.status.name());
        }
        if (this.priority != Integer.MIN_VALUE) {
            text.append(" (").append(this.priority).append(")");
        }
        if (this.statusmessage != null) {
            text.append("<br>Status message:<br>").append(this.statusmessage);
        }
        text.append("</html>");
        return text.toString();
    }

    @Override
    public JLabel getView() {
        JLabel view = new JLabel();
        view.setPreferredSize(new Dimension(800, 20));
        if (!this.hasNewMessage) {
            view.setIcon(PluginClientListener.statusIcon.get(this.status));
        } else {
            view.setIcon(PluginClientListener.emailIcon);
        }
        view.setText(this.getViewableName());
        return view;
    }

    @Override
    public void loadNode(IRosterItem elementEntryI) {
        RosterEntryItem elementEntry = (RosterEntryItem)elementEntryI;
        this.jid = elementEntry.from;
        this.name = elementEntry.name;
        this.priority = elementEntry.priority;
        this.status = elementEntry.status;
        this.subscr = elementEntry.subscr;
        this.statusmessage = elementEntry.statusmessage;
    }

    public String getJid() {
        return this.jid;
    }

    public void setStatus(IMConstants.STATUS status) {
        this.status = status;
    }

    public IMConstants.STATUS getStatus() {
        return this.status;
    }

    public String getViewableName() {
        Object retname = this.name;
        if (this.name != null && this.name.length() > 0) {
            String jidres = IMUtils.getJIDResource((String)this.jid);
            if (jidres != null) {
                retname = this.name + "/" + jidres;
            }
        } else {
            retname = this.jid;
        }
        return retname;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getJson() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        if (this.jid != null) {
            sb.append("'from':'").append(this.jid).append("',");
        }
        if (this.name != null) {
            sb.append("'name':'").append(this.name).append("',");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(RosterTreeNodeEntry o) {
        if (this.status != IMConstants.STATUS.OFFLINE && o.status == IMConstants.STATUS.OFFLINE) {
            return -1;
        }
        if (this.status == IMConstants.STATUS.OFFLINE && o.status != IMConstants.STATUS.OFFLINE) {
            return 1;
        }
        return this.getViewableName().compareTo(o.getViewableName());
    }

    @Override
    public String toString() {
        return "[entry:jid=" + this.jid + ",name=" + this.name + "]";
    }

    @Override
    public JPopupMenu getPopupMenu() {
        RosterTreeNodeGroup groupNode = this.tree.getEntry2groupMap().get(IMUtils.getPureJID((String)this.jid));
        if (groupNode == null) {
            return null;
        }
        String groupName = groupNode.getName();
        JPopupMenu menuPopup = new JPopupMenu();
        JMenuItem openChatContactItem = new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0430\u0442");
        openChatContactItem.setActionCommand("openChatContactItem");
        openChatContactItem.addActionListener(e -> PluginClientListener.imManager.openChatContactDialog(this.jid));
        JMenuItem renameContactItem = new JMenuItem("\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442...");
        renameContactItem.setActionCommand("renameContactItem");
        renameContactItem.addActionListener(e -> PluginClientListener.imManager.renameContactDialog(this.jid, this.name));
        JMenuItem removeContactItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442");
        removeContactItem.setActionCommand("removeContactItem");
        removeContactItem.addActionListener(e -> PluginClientListener.imManager.removeContactDialog(this.jid));
        JMenu submenuGroupPopup = new JMenu("\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432 \u0433\u0440\u0443\u043f\u043f\u0443");
        ButtonGroup groupButtonMenu = new ButtonGroup();
        JRadioButtonMenuItem noneGroupItem = new JRadioButtonMenuItem("\u0412 \u043d\u0438\u043a\u0430\u043a\u0443\u044e (General)");
        noneGroupItem.setActionCommand("MoveToGroupGeneralItem");
        noneGroupItem.addActionListener(e -> PluginClientListener.imManager.moveContactToGroupDialog(this.jid, "General"));
        groupButtonMenu.add(noneGroupItem);
        if ("General".equals(groupName)) {
            noneGroupItem.setSelected(true);
        }
        JMenuItem newGroupAndMoveItem = new JMenuItem("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e...");
        newGroupAndMoveItem.setActionCommand("newGroupAndMoveItem");
        newGroupAndMoveItem.addActionListener(e -> PluginClientListener.imManager.newGroupAndMoveContactDialog(this.jid));
        ArrayList<JRadioButtonMenuItem> groupMenuItems = new ArrayList<JRadioButtonMenuItem>();
        for (RosterTreeNodeGroup rosterTreeNodeGroup : this.tree.getGroupMap().values()) {
            if (IMConstants.isReservedGroupName((String)rosterTreeNodeGroup.getName())) continue;
            JRadioButtonMenuItem nGroupItem = new JRadioButtonMenuItem(rosterTreeNodeGroup.getName());
            nGroupItem.setActionCommand("MoveToGroup" + rosterTreeNodeGroup.getName() + "Item");
            nGroupItem.addActionListener(e -> PluginClientListener.imManager.moveContactToGroupDialog(this.jid, group.getName()));
            groupButtonMenu.add(nGroupItem);
            groupMenuItems.add(nGroupItem);
            if (!rosterTreeNodeGroup.getName().equals(groupName)) continue;
            nGroupItem.setSelected(true);
        }
        if ("Self".equals(groupName) || "Transport".equals(groupName)) {
            renameContactItem.setEnabled(false);
            submenuGroupPopup.setEnabled(false);
            removeContactItem.setEnabled(false);
        }
        menuPopup.add(openChatContactItem);
        menuPopup.add(new JSeparator(0));
        menuPopup.add(renameContactItem);
        menuPopup.add(submenuGroupPopup);
        submenuGroupPopup.add(noneGroupItem);
        submenuGroupPopup.add(new JSeparator(0));
        for (JMenuItem jMenuItem : groupMenuItems) {
            submenuGroupPopup.add(jMenuItem);
        }
        submenuGroupPopup.add(new JSeparator(0));
        submenuGroupPopup.add(newGroupAndMoveItem);
        menuPopup.add(removeContactItem);
        return menuPopup;
    }

    public void setMessaged(boolean hasNewMessage) {
        this.hasNewMessage = hasNewMessage;
    }
}

