/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionMapCall;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterfaceSelector;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServTypeDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionLogDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;

public class ConnectionMapCallProccess
extends ConnectionMapCall {
    private static final Logger logger = LogManager.getLogger();
    private final Date day;
    private final Integer deviceId;
    private List<InetConnectionCallRuntime> sessions = new ArrayList<InetConnectionCallRuntime>();
    protected Set<Long> currentSessionSet = new HashSet<Long>();

    public ConnectionMapCallProccess(Accounting accounting, Date day, Integer deviceId) throws BGException {
        super(accounting);
        this.day = day;
        this.deviceId = deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConnectionSet connectionSet) throws BGException {
        logger.info("Init call sessions");
        Connection con = connectionSet.getConnection();
        Set agentDeviceIds = null;
        InetDevice device = null;
        try (InetDeviceDao inetDeviceDao = new InetDeviceDao(con, this.accounting.moduleId);){
            device = inetDeviceDao.get(this.deviceId);
            agentDeviceIds = Id.newIdSet((Id)device);
        }
        Date dateFrom = this.day;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.day);
        ((Calendar)cal).add(5, 1);
        Date dateTo = cal.getTime();
        FlowAgentInterfaceSelector ifaceSelector = new FlowAgentInterfaceSelector(this.accounting, agentDeviceIds, 1, 2, 5, 3, 4);
        HashSet<Integer> deviceIds = new HashSet<Integer>();
        FlowAgent flowAgent = ifaceSelector.getAgentIdMap().get(this.deviceId);
        if (flowAgent != null) {
            for (Map.Entry<Integer, FlowAgentInterface> entry : flowAgent.getIfaceMap().entrySet()) {
                FlowAgentInterface iface = entry.getValue();
                for (Integer devId : iface.deviceIds) {
                    deviceIds.add(devId);
                }
            }
        }
        deviceIds.add(this.deviceId);
        try (InetServTypeDao inetServTypeDao = new InetServTypeDao(con, this.accounting.moduleId);
             InetSessionLogDao sessionLogDao = new InetSessionLogDao(con, this.accounting.moduleId, this.day);){
            boolean isCurrentDay;
            List<InetSessionLog> sessionList = sessionLogDao.list(deviceIds, dateFrom, dateTo);
            InetSessionDao inetSessionDao = new InetSessionDao(con, this.accounting.moduleId);
            Date now = new Date();
            int daylDelta = TimeUtils.daysDelta((Date)now, (Date)this.day);
            boolean bl = isCurrentDay = daylDelta == 0;
            if (isCurrentDay) {
                List<InetSessionLog> currentSessions = inetSessionDao.listAsLog(inetServTypeDao.list(), deviceIds, null, null, null, dateFrom, dateTo, null, 0, 0, false);
                for (InetSessionLog session : currentSessions) {
                    this.currentSessionSet.add(session.getId());
                }
                sessionList.addAll(currentSessions);
            }
            for (InetSessionLog session : sessionList) {
                InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(session.getServId());
                if (session.getSessionStop() != null) {
                    cal.setTime(session.getSessionStop());
                    cal.set(14, 0);
                    ((Calendar)cal).add(14, 999);
                    Date timeTo = cal.getTime();
                    session.setSessionStop(timeTo);
                }
                InetConnection connection = new InetConnection(session);
                try {
                    if (inetServRuntime == null) {
                        logger.warn("InetServRuntime not found for id=" + session.getServId());
                        continue;
                    }
                    if (session.getSessionStart() == null) {
                        logger.warn("InetSession is null or sessionStart is null for session:" + session.getId());
                        continue;
                    }
                    inetServRuntime.lock();
                    InetConnectionCallRuntime newConnectionRuntime = new InetConnectionCallRuntime(this.accounting, inetServRuntime, connection, (InetSession)session, session.getRealm(), null, device.getId(), session.getDevicePort(), false, null);
                    try {
                        if (inetServRuntime.inetServTypeRef.get().inetServType.getSessionInitiationType() == 0) {
                            if (newConnectionRuntime.connection.getInetAddressBytes() != null) {
                                // empty if block
                            }
                        } else {
                            newConnectionRuntime.rangeSets = new IpRangeRuntime[]{new IpRangeRuntime(inetServRuntime.getInetServ().getAddressFrom(), inetServRuntime.getInetServ().getAddressTo(), newConnectionRuntime)};
                        }
                    }
                    finally {
                        inetServRuntime.unlock();
                    }
                    this.sessions.add(newConnectionRuntime);
                }
                catch (Exception ex) {
                    logger.error("Problem with connectionId: " + session.getConnectionId() + ", sessionId: " + session.getId() + " restore, " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public Collection<InetConnectionCallRuntime> values() {
        return this.sessions;
    }

    public Set<Long> getCurrentSessionSet() {
        return this.currentSessionSet;
    }
}

