/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.worker.WorkerTask;

abstract class AbstractEventWorker
extends WorkerTask<ServerContext>
implements EventListener<Event>,
Runnable {
    private static final Logger logger = LogManager.getLogger();
    private final ReentrantLock lock = new ReentrantLock();
    private final ReentrantLock linkLock = new ReentrantLock();
    private final ReentrantLock runLock = new ReentrantLock();
    private final ScheduledExecutorService scheduledExecutorService;
    protected volatile boolean linked = false;
    protected volatile boolean connected = false;
    private volatile boolean destroy = false;
    private volatile ScheduledFuture<?> future = null;
    protected final int capacity;
    private final int maxCapacity;
    protected volatile long errorPause;
    protected final AtomicInteger count = new AtomicInteger();
    protected final BlockingQueue<Object> taskQueue;
    protected final BlockingDeque<Object> taskDequeue;
    protected volatile boolean needUnlink;

    public AbstractEventWorker(ScheduledExecutorService scheduledExecutorService, BlockingQueue<Object> taskQueue, int capacity, int maxCapacity, long errorPause) throws BGException {
        this.scheduledExecutorService = scheduledExecutorService;
        this.taskQueue = taskQueue;
        this.taskDequeue = taskQueue instanceof BlockingDeque ? (BlockingDeque)taskQueue : null;
        this.capacity = capacity;
        this.maxCapacity = maxCapacity;
        this.errorPause = errorPause;
    }

    protected void putFirst(Object task) throws InterruptedException {
        if (this.taskDequeue != null) {
            this.taskDequeue.putFirst(task);
        } else {
            this.taskQueue.put(task);
        }
    }

    protected final void link() throws BGException {
        logger.debug("Linking...");
        this.linkLock.lock();
        try {
            this.needUnlink = false;
            if (!this.linked && !this.destroy) {
                this.linkImpl();
                this.linked = true;
            }
        }
        finally {
            this.linkLock.unlock();
        }
        logger.debug("Linked");
    }

    protected abstract void linkImpl() throws BGException;

    private void unlink() throws BGException {
        logger.debug("Unlinking...");
        this.linkLock.lock();
        try {
            if (this.linked) {
                this.unlinkImpl();
                this.linked = false;
            }
        }
        finally {
            this.linkLock.unlock();
        }
        logger.debug("Unlinked");
    }

    protected void unlinkImpl() throws BGException {
        EventProcessor.getInstance().removeListener((EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.lock.lock();
        try {
            boolean needUnlink;
            logger.info("Queue size=" + this.taskQueue.size());
            int count = this.count.get();
            boolean bl = this.connected ? count >= this.maxCapacity : (needUnlink = count >= this.capacity);
            if (needUnlink) {
                logger.info("Queue count=" + count + ">=" + this.capacity + "(" + this.maxCapacity + "). Need unlink.");
                this.needUnlink = true;
                this.scheduleUnlink();
            }
            logger.info("Try schedule task");
            this.schedule(0L);
            if (!this.taskQueue.offer(e)) {
                this.needUnlink = true;
                this.scheduleUnlink();
                throw new BGException("Queue is full!!!");
            }
            this.count.incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void schedule(long timeout) {
        ScheduledFuture<?> future = this.future;
        if (future == null || future.isCancelled() || future.isDone()) {
            logger.info("Schedule task");
            this.future = this.scheduledExecutorService.schedule(this, timeout, TimeUnit.MILLISECONDS);
        }
    }

    protected void scheduleUnlink() {
        logger.info("Schedule unlink.");
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                block5: {
                    AbstractEventWorker.this.linkLock.lock();
                    try {
                        if (!AbstractEventWorker.this.needUnlink) break block5;
                        try {
                            AbstractEventWorker.this.unlink();
                        }
                        catch (BGException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        AbstractEventWorker.this.needUnlink = false;
                    }
                    finally {
                        AbstractEventWorker.this.linkLock.unlock();
                    }
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runImpl() {
        try {
            if (!this.runLock.tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return;
        }
        try {
            if (this.needUnlink) {
                this.needUnlink = false;
                this.unlink();
            }
            this.future = null;
            this.runWorker();
        }
        catch (Throwable e) {
            logger.error(this.getClass() + ": " + e.getMessage(), e);
            this.lock.lock();
            try {
                ScheduledFuture<?> future = this.future;
                if (future != null) {
                    future.cancel(false);
                }
                this.future = this.scheduledExecutorService.schedule(this, this.errorPause, TimeUnit.MILLISECONDS);
                logger.info("Execution error - waiting " + this.errorPause + "ms for next try.");
            }
            finally {
                this.lock.unlock();
            }
        }
        finally {
            this.runLock.unlock();
        }
    }

    protected abstract void runWorker() throws BGException;

    public void shutdown() throws BGException {
        this.unlink();
        this.destroy = true;
    }
}

