/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import bitel.billing.module.common.BGControlPanelDateAndHours;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.inet.client.contract.InetContractErrorTableModel;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.service.InetAuthErrorService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class InetErrorPanel
extends ServicePanel {
    private JPanel tablePanel = null;
    private CardLayout cardLayout = new CardLayout();
    private BGTableModel<InetAuthError> errorModel = new InetContractErrorTableModel("inetError");
    private BGUTable errorTable = new BGUTable(this.errorModel);
    private BGControlPanelDateAndHours period = new BGControlPanelDateAndHours();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel label = new JLabel("\u0418\u0442\u043e\u0433\u043e: 0");
    private Integer inetServId;
    private InetAuthErrorService wsAuthError = (InetAuthErrorService)this.getContext().getPort(InetAuthErrorService.class);

    public InetErrorPanel(ClientContext clientContext) {
        super(clientContext);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.period.addActionListener(e -> this.setData());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.topPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setInetServId(int inetServId) {
        this.inetServId = inetServId;
    }

    private JPanel topPanel() {
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        JPanel periodPanel = new JPanel(new GridBagLayout());
        periodPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)" \u041f\u0435\u0440\u0438\u043e\u0434 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.add((Component)this.label, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pagePanel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)periodPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)pagePanel, (String)" C\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    private JPanel tablePanel() {
        this.tablePanel = new JPanel(this.cardLayout);
        this.tablePanel.add((Component)new JScrollPane((Component)this.errorTable), "error");
        return this.tablePanel;
    }

    public void setData() {
        Date timeTo;
        Date timeFrom;
        if (this.period.getDate() != null) {
            timeFrom = this.period.getDate();
            timeTo = TimeUtils.getNextDay((Date)this.period.getDate());
        } else {
            timeFrom = TimeUtils.subtractHoursFromNow((int)this.period.getHourFrom());
            timeTo = TimeUtils.subtractHoursFromNow((int)this.period.getHourTo());
        }
        try {
            HashSet<Integer> contractIds = new HashSet<Integer>();
            contractIds.add(this.getContext().getContractId());
            HashSet<Integer> serviceIds = new HashSet<Integer>();
            serviceIds.add(this.inetServId);
            Result result = this.wsAuthError.authErrorDateList(timeFrom, timeTo, null, contractIds, serviceIds, null, null, this.pagePanel.getPage());
            this.pagePanel.setPage(result.getPage());
            this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
            this.errorModel.setData(result.getList());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

