/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import ru.bitel.bgbilling.common.bean.IPUtils;

public class TrafficAnalizeReport {
    private Map<Long, Long> incomingBytes = new HashMap<Long, Long>();
    private Map<Long, Long> outgoingBytes = new HashMap<Long, Long>();

    public void addToHost(long host, long bytes) {
        Long currentValue = this.outgoingBytes.get(host);
        if (currentValue == null) {
            currentValue = 0L;
        }
        currentValue = currentValue + bytes;
        this.outgoingBytes.put(host, currentValue);
    }

    public void addFromHost(long host, long bytes) {
        Long currentValue = this.incomingBytes.get(host);
        if (currentValue == null) {
            currentValue = 0L;
        }
        currentValue = currentValue + bytes;
        this.incomingBytes.put(host, currentValue);
    }

    public void addAnalize(StringBuilder report) {
        report.append("\u041f\u0430\u043a\u0435\u0442\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u043b\u0438\u0441\u044c \u043d\u0430 ");
        report.append(this.outgoingBytes.keySet().size());
        report.append(" \u0445\u043e\u0441\u0442\u043e\u0432\n");
        this.addTopHost(this.outgoingBytes, report);
        report.append("\u041f\u0430\u043a\u0435\u0442\u044b \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u043b\u0438\u0441\u044c \u0441 ");
        report.append(this.incomingBytes.keySet().size());
        report.append(" \u0445\u043e\u0441\u0442\u043e\u0432\n");
        this.addTopHost(this.incomingBytes, report);
    }

    private void addTopHost(Map<Long, Long> map, StringBuilder report) {
        TreeMap<Long, Long> treeMap = new TreeMap<Long, Long>();
        for (Map.Entry<Long, Long> me : map.entrySet()) {
            treeMap.put(me.getValue(), me.getKey());
        }
        int cnt = 0;
        NavigableMap topMap = treeMap.descendingMap();
        Iterator it = topMap.entrySet().iterator();
        Map.Entry me = null;
        while (it.hasNext() && cnt++ < 3) {
            me = it.next();
            report.append(IPUtils.convertLongIpToString((long)((Long)me.getValue())));
            report.append("=>");
            report.append(me.getKey());
            report.append("\n");
        }
    }
}

