/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionResultContentType;
import java.text.NumberFormat;
import java.util.Locale;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.common.Utils;

public class ActionGetBalanceInformerData
extends AbstractAction {
    public ActionGetBalanceInformerData() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(this.context.getConnectionSet(), this.contractId, System.currentTimeMillis());
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        String acceptLanguage = this.context.getRequest().getHeader("Accept-Language");
        if (Utils.notBlankString((String)acceptLanguage)) {
            locale = new Locale(acceptLanguage.split(",")[0].split(";")[0].split("-")[0]);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        this.setResultParam("contentType", (Object)ActionResultContentType.json);
        this.setResultParam("sum", numberFormat.format(convergenceBalance.getBalance()));
        this.setResultParam("currencyTitleMedium", this.setup.get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
    }
}

