/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.bean;

import bitel.billing.server.tariff.bean.TimeLimitSet;
import bitel.billing.server.tariff.bean.TimeType;
import bitel.billing.server.tariff.bean.TimeTypeManger;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.timetype.event.TimeTypesChangedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class TimeTypeCache {
    private static final Logger log = LoggerFactory.getLogger(TimeTypeCache.class);
    private static volatile Map<Integer, TimeLimitSet> limitMap;
    private static volatile long reloadTime;
    private static volatile Thread reloadThread;
    private static final long RELOAD_AFTER_CORRECT = 60000L;
    private static Object loadMutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, TimeLimitSet> getLimitMap() {
        if (limitMap == null) {
            Object object = loadMutex;
            synchronized (object) {
                TimeTypeCache.loadTimeTypes();
            }
        }
        return limitMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTimeTypes() {
        log.info("Reloading time types..");
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            HashMap<Integer, TimeLimitSet> limitMap = new HashMap<Integer, TimeLimitSet>();
            for (TimeType type : new TimeTypeManger(con).getTypeList()) {
                String data = type.getData();
                limitMap.put(type.getId(), new TimeLimitSet(data));
            }
            TimeTypeCache.limitMap = limitMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    static {
        new Thread("TimeTypeCacheInit"){

            @Override
            public void run() {
                try {
                    EventProcessor.getInstance().addListener(new EventListener<TimeTypesChangedEvent>(){

                        @Override
                        public void notify(TimeTypesChangedEvent e, EventListenerContext ctx) throws BGException {
                            reloadTime = System.currentTimeMillis() + 60000L;
                            if (reloadThread == null) {
                                reloadThread = new ReloadThread();
                            }
                        }
                    }, TimeTypesChangedEvent.class);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }.start();
        loadMutex = new Object();
    }

    private static class ReloadThread
    extends Thread {
        public ReloadThread() {
            this.start();
        }

        @Override
        public void run() {
            try {
                while (System.currentTimeMillis() < reloadTime) {
                    ReloadThread.sleep(reloadTime - System.currentTimeMillis());
                }
                TimeTypeCache.loadTimeTypes();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                reloadThread = null;
            }
        }
    }
}

