/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import bitel.billing.module.common.table.BGRadio;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class RadioTableCellEditor
extends AbstractCellEditor
implements ActionListener,
TableCellEditor {
    private JRadioButton editor = new JRadioButton();
    private Object value = null;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        if (value != null && value instanceof BGRadio) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                Object cellValue = table.getValueAt(i, column);
                if (cellValue == null || !(cellValue instanceof BGRadio)) continue;
                ((BGRadio)cellValue).setSelected(false);
            }
            this.editor.setText(value.toString());
            this.editor.setSelected(((BGRadio)value).isSelected());
            this.editor.addActionListener(this);
            table.revalidate();
            table.repaint();
            return this.editor;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    @Override
    public boolean stopCellEditing() {
        this.editor.removeActionListener(this);
        return this.editor.isSelected();
    }

    @Override
    public Object getCellEditorValue() {
        if (this.value != null && this.value instanceof BGRadio) {
            ((BGRadio)this.value).setSelected(this.editor.isSelected());
        }
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        Object source = anEvent.getSource();
        if (anEvent instanceof MouseEvent && source instanceof BGTable) {
            Object value;
            BGTable table = (BGTable)source;
            Point p = ((MouseEvent)anEvent).getPoint();
            int row = table.rowAtPoint(p);
            int column = table.columnAtPoint(p);
            if (column > -1 && row > -1 && (value = table.getValueAt(row, column)) != null && value instanceof BGRadio) {
                return !((BGRadio)value).isSelected();
            }
        }
        return false;
    }
}

