/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action;

import bitel.billing.server.ActionBase;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class ActionGetPackageItems
extends ActionBase {
    public void doAction() throws Exception {
        int packageId = this.getIntParameter("package_id", -1);
        if (this.mid <= 0 || packageId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        LicenseManager licenseManager = new LicenseManager(this.con, this.mid);
        List<ConfirmedOrder> packageItems = licenseManager.getLicenseItems(packageId, false);
        License license = licenseManager.getLicenseById(packageId);
        Copy copy = licenseManager.getCopy(license.getCopyId());
        Map<String, BigDecimal> packageItemCosts = this.getPackageItemsCosts(packageItems, copy);
        BigDecimal totalCost = BigDecimal.ZERO;
        String type = new String();
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        for (int i = 0; i < packageItems.size(); ++i) {
            ConfirmedOrder item = packageItems.get(i);
            Element row = this.createElement(data, "row");
            row.setAttribute("index", String.valueOf(i + 1));
            row.setAttribute("ids", item.getIds());
            row.setAttribute("product_item_id", String.valueOf(item.getComponentId()));
            row.setAttribute("product_item_title", item.getComponentTitle());
            row.setAttribute("product_item_name", item.getComponentName());
            row.setAttribute("to_date", TimeUtils.format((Date)item.getDateTo(), (String)"dd.MM.yyyy"));
            BigDecimal itemCost = packageItemCosts.get(item.getComponentName());
            if (item.getType() == OrderType.TEST.getCode() || itemCost == null) {
                itemCost = BigDecimal.ZERO;
            }
            totalCost = totalCost.add(itemCost);
            row.setAttribute("cost", formatter.format(itemCost));
            if (item.getType() == OrderType.TEST.getCode()) {
                type = OrderType.TEST.getText();
            } else if (item.getType() == OrderType.BUY.getCode()) {
                type = OrderType.BUY.getText();
            }
            row.setAttribute("type", type);
            String count = item.getCount() > 0 ? String.valueOf(item.getCount()) : "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e";
            row.setAttribute("count", count);
        }
        String licText = licenseManager.getLicenseText(packageId);
        Element lic = this.createElement(this.rootNode, "lic");
        lic.setAttribute("value", licText);
        String originalLicText = licenseManager.getOriginalLicenseText(packageId);
        Element originalLic = this.createElement(this.rootNode, "originalLic");
        originalLic.setAttribute("value", originalLicText);
        String licenseCost = formatter.format(totalCost);
        Element cost = this.createElement(this.rootNode, "cost");
        cost.setAttribute("value", licenseCost);
        try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
            int emailParameterId = this.moduleSetup.getInt("license.email.parameter.id", 0);
            if (emailParameterId > 0) {
                String recipientList = contractDao.getEmailFromContractParameter(this.cid, emailParameterId);
                Element emails = this.createElement(this.rootNode, "emails");
                String emailListString = recipientList != null ? recipientList.replaceAll("\n", ";") : "";
                emails.setAttribute("value", emailListString);
            }
        }
    }

    private Map<String, BigDecimal> getPackageItemsCosts(List<ConfirmedOrder> packageItems, Copy copy) {
        String version = copy.getProductVersion();
        String url = LicenseUtils.buildLicenseCostUrlRequest(packageItems, version, (ParameterMap)this.moduleSetup);
        return LicenseUtils.getCosts(url);
    }
}

